/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.WildcardType;
import java.util.List;
import org.jsonschema2pojo.exception.GenerationException;

public class TypeUtil {
    public static JClass resolveType(JClassContainer _package, String typeDefinition) {
        try {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)JavaParser.parseBodyDeclaration((String)(typeDefinition + " foo;"));
            ClassOrInterfaceType c = (ClassOrInterfaceType)((ReferenceType)fieldDeclaration.getType()).getType();
            return TypeUtil.buildClass(_package, c, 0);
        }
        catch (ParseException e) {
            throw new GenerationException("Couldn't parse type: " + typeDefinition, e);
        }
    }

    private static JClass buildClass(JClassContainer _package, ClassOrInterfaceType c, int arrayCount) {
        String packagePrefix = c.getScope() != null ? c.getScope().toString() + "." : "";
        JClass _class = _package.owner().ref(packagePrefix + c.getName());
        for (int i = 0; i < arrayCount; ++i) {
            _class = _class.array();
        }
        List typeArgs = c.getTypeArgs();
        if (typeArgs != null && typeArgs.size() > 0) {
            JClass[] genericArgumentClasses = new JClass[typeArgs.size()];
            for (int i = 0; i < typeArgs.size(); ++i) {
                JClass resolvedClass;
                Type type = (Type)typeArgs.get(i);
                if (type instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)type;
                    if (wildcardType.getSuper() != null) {
                        throw new IllegalArgumentException("\"? super \" declaration is not yet supported");
                    }
                    resolvedClass = wildcardType.getExtends() != null ? TypeUtil.buildClass(_package, (ClassOrInterfaceType)wildcardType.getExtends().getType(), 0).wildcard() : _package.owner().ref(Object.class).wildcard();
                } else {
                    ReferenceType referenceType = (ReferenceType)type;
                    resolvedClass = TypeUtil.buildClass(_package, (ClassOrInterfaceType)referenceType.getType(), referenceType.getArrayCount());
                }
                genericArgumentClasses[i] = resolvedClass;
            }
            _class = _class.narrow(genericArgumentClasses);
        }
        return _class;
    }
}

