/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtil.class);
    private static final Base64 BASE_64_CODEC = new Base64(0);

    protected HttpUtil() {
        throw new UnsupportedOperationException();
    }

    public static String generateToken(final String server) throws IOException, InterruptedException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        LOG.debug("The user credential is {}", (Object)currentUser);
        String challenge = (String)currentUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                try {
                    GSSManager manager = GSSManager.getInstance();
                    GSSName serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                    GSSContext gssContext = manager.createContext(serverName.canonicalize(null), null, null, 0);
                    gssContext.requestMutualAuth(true);
                    gssContext.requestCredDeleg(true);
                    byte[] inToken = new byte[]{};
                    byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
                    gssContext.dispose();
                    LOG.debug("Got valid challenge for host {}", (Object)serverName);
                    return new String(BASE_64_CODEC.encode(outToken), StandardCharsets.US_ASCII);
                }
                catch (GSSException e) {
                    LOG.error("Error: ", (Throwable)e);
                    throw new AuthenticationException((Throwable)e);
                }
            }
        });
        return challenge;
    }

    public static WebResource.Builder connect(String url) throws URISyntaxException, IOException, InterruptedException {
        boolean useKerberos = UserGroupInformation.isSecurityEnabled();
        URI resource = new URI(url);
        Client client = Client.create();
        WebResource.Builder builder = client.resource(url).type("application/json");
        if (useKerberos) {
            String challenge = HttpUtil.generateToken(resource.getHost());
            builder.header("Authorization", (Object)("Negotiate " + challenge));
            LOG.debug("Authorization: Negotiate {}", (Object)challenge);
        }
        return builder;
    }
}

