/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.CollectionType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreFactory;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DocumentStoreWriter;
import org.apache.hadoop.yarn.server.timelineservice.metrics.PerNodeAggTimelineCollectorMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineCollectionWriter<Document extends TimelineDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCollectionWriter.class);
    private static final String DOCUMENT_BUFFER_SIZE_CONF = "yarn.timeline-service.document-buffer.size";
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final int AWAIT_TIMEOUT_SECS = 5;
    private static final PerNodeAggTimelineCollectorMetrics METRICS = PerNodeAggTimelineCollectorMetrics.getInstance();
    private final CollectionType collectionType;
    private final DocumentStoreWriter<Document> documentStoreWriter;
    private final Map<String, Document> documentsBuffer;
    private final int maxBufferSize;
    private final ScheduledExecutorService scheduledDocumentsFlusher;
    private final ExecutorService documentsBufferFullFlusher;

    public TimelineCollectionWriter(CollectionType collectionType, Configuration conf) throws YarnException {
        LOG.info("Initializing TimelineCollectionWriter for collection type : {}", (Object)collectionType);
        int flushIntervalSecs = conf.getInt("yarn.timeline-service.writer.flush-interval-seconds", 60);
        this.maxBufferSize = conf.getInt(DOCUMENT_BUFFER_SIZE_CONF, 1024);
        this.documentsBuffer = new HashMap<String, Document>(this.maxBufferSize);
        this.collectionType = collectionType;
        this.documentStoreWriter = DocumentStoreFactory.createDocumentStoreWriter(conf);
        this.scheduledDocumentsFlusher = Executors.newSingleThreadScheduledExecutor();
        this.scheduledDocumentsFlusher.scheduleAtFixedRate(this::flush, flushIntervalSecs, flushIntervalSecs, TimeUnit.SECONDS);
        this.documentsBufferFullFlusher = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocument(Document timelineDocument) {
        long startTime = Time.monotonicNow();
        Map<String, Document> map = this.documentsBuffer;
        synchronized (map) {
            TimelineDocument prevDocument;
            if (this.documentsBuffer.size() == this.maxBufferSize) {
                Map<String, Document> flushedBuffer = this.copyToFlushBuffer();
                this.documentsBufferFullFlusher.execute(() -> this.flush(flushedBuffer));
            }
            if ((prevDocument = (TimelineDocument)this.documentsBuffer.get(timelineDocument.getId())) != null) {
                prevDocument.merge(timelineDocument);
            } else {
                prevDocument = timelineDocument;
            }
            this.documentsBuffer.put(prevDocument.getId(), prevDocument);
        }
        METRICS.addAsyncPutEntitiesLatency(Time.monotonicNow() - startTime, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Document> copyToFlushBuffer() {
        HashMap<String, Document> flushBuffer = new HashMap<String, Document>();
        Map<String, Document> map = this.documentsBuffer;
        synchronized (map) {
            if (this.documentsBuffer.size() > 0) {
                flushBuffer.putAll(this.documentsBuffer);
                this.documentsBuffer.clear();
            }
        }
        return flushBuffer;
    }

    private void flush(Map<String, Document> flushBuffer) {
        for (TimelineDocument document : flushBuffer.values()) {
            this.documentStoreWriter.writeDocument(document, this.collectionType);
        }
    }

    public void flush() {
        this.flush(this.copyToFlushBuffer());
    }

    public void close() throws Exception {
        this.scheduledDocumentsFlusher.shutdown();
        this.documentsBufferFullFlusher.shutdown();
        this.flush();
        this.scheduledDocumentsFlusher.awaitTermination(5L, TimeUnit.SECONDS);
        this.documentsBufferFullFlusher.awaitTermination(5L, TimeUnit.SECONDS);
        this.documentStoreWriter.close();
    }
}

