/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class BlockResolver {
    protected HdfsProtos.BlockProto buildBlock(long blockId, long bytes) {
        return this.buildBlock(blockId, bytes, 1001L);
    }

    protected HdfsProtos.BlockProto buildBlock(long blockId, long bytes, long genstamp) {
        HdfsProtos.BlockProto.Builder b = HdfsProtos.BlockProto.newBuilder().setBlockId(blockId).setNumBytes(bytes).setGenStamp(genstamp);
        return b.build();
    }

    public Iterable<HdfsProtos.BlockProto> resolve(FileStatus s) {
        List<Long> lengths = this.blockLengths(s);
        ArrayList<HdfsProtos.BlockProto> ret = new ArrayList<HdfsProtos.BlockProto>(lengths.size());
        long tot = 0L;
        for (long l : lengths) {
            tot += l;
            ret.add(this.buildBlock(this.nextId(), l));
        }
        if (tot != s.getLen()) {
            throw new IllegalStateException("Expected " + s.getLen() + " found " + tot);
        }
        return ret;
    }

    public abstract long nextId();

    protected abstract long lastId();

    protected abstract List<Long> blockLengths(FileStatus var1);

    public long preferredBlockSize(FileStatus status) {
        return status.getBlockSize();
    }

    public abstract int getReplication(FileStatus var1);
}

