/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.impl.HBaseMetrics2HadoopMetricsAdapter;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystemHelper;
import org.apache.hadoop.metrics2.lib.MetricsExecutorImpl;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class GlobalMetricRegistriesAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalMetricRegistriesAdapter.class);
    private final MetricsExecutor executor = new MetricsExecutorImpl();
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final DefaultMetricsSystemHelper helper;
    private final HBaseMetrics2HadoopMetricsAdapter metricsAdapter = new HBaseMetrics2HadoopMetricsAdapter();
    private final HashMap<MetricRegistryInfo, MetricsSourceAdapter> registeredSources = new HashMap();

    private GlobalMetricRegistriesAdapter() {
        this.helper = new DefaultMetricsSystemHelper();
        this.executor.getExecutor().scheduleAtFixedRate(() -> this.doRun(), 10L, 10L, TimeUnit.SECONDS);
    }

    public static GlobalMetricRegistriesAdapter init() {
        return new GlobalMetricRegistriesAdapter();
    }

    public void stop() {
        this.stopped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        if (this.stopped.get()) {
            this.executor.stop();
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("doRun called: " + this.registeredSources);
        }
        Collection registries = MetricRegistries.global().getMetricRegistries();
        for (MetricRegistry registry : registries) {
            MetricRegistryInfo info = registry.getMetricRegistryInfo();
            if (info.isExistingSource() || this.registeredSources.containsKey(info)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering adapter for the MetricRegistry: " + info.getMetricsJmxContext());
            }
            MetricsSourceAdapter adapter = new MetricsSourceAdapter(registry);
            LOG.info("Registering " + info.getMetricsJmxContext() + " " + info.getMetricsDescription());
            DefaultMetricsSystem.instance().register(info.getMetricsJmxContext(), info.getMetricsDescription(), (Object)adapter);
            this.registeredSources.put(info, adapter);
        }
        boolean removed = false;
        Iterator<Map.Entry<MetricRegistryInfo, MetricsSourceAdapter>> it = this.registeredSources.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<MetricRegistryInfo, MetricsSourceAdapter> entry = it.next();
            MetricRegistryInfo info = entry.getKey();
            Optional found = MetricRegistries.global().get(info);
            if (found.isPresent()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing adapter for the MetricRegistry: " + info.getMetricsJmxContext());
            }
            MetricsSystem metricsSystem = DefaultMetricsSystem.instance();
            synchronized (metricsSystem) {
                DefaultMetricsSystem.instance().unregisterSource(info.getMetricsJmxContext());
                this.helper.removeSourceName(info.getMetricsJmxContext());
                this.helper.removeObjectName(info.getMetricsJmxContext());
                it.remove();
                removed = true;
            }
        }
        if (removed) {
            JmxCacheBuster.clearJmxCache();
        }
    }

    private class MetricsSourceAdapter
    implements MetricsSource {
        private final MetricRegistry registry;

        MetricsSourceAdapter(MetricRegistry registry) {
            this.registry = registry;
        }

        public void getMetrics(MetricsCollector collector, boolean all) {
            GlobalMetricRegistriesAdapter.this.metricsAdapter.snapshotAllMetrics(this.registry, collector);
        }
    }
}

