/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.minbin;

import java.util.HashMap;
import org.nustaq.serialization.minbin.MBIn;
import org.nustaq.serialization.minbin.MBOut;
import org.nustaq.serialization.minbin.MBPrinter;
import org.nustaq.serialization.minbin.MBTags;

public class MinBin {
    public static final Object END_MARKER = "_E_";
    public static MinBin DefaultInstance = new MinBin();
    public static final byte INT_8 = 1;
    public static final byte INT_16 = 2;
    public static final byte INT_32 = 3;
    public static final byte INT_64 = 4;
    public static final byte TAG = 5;
    public static final byte END = 6;
    public static final byte RESERV = 7;
    public static final byte UNSIGN_MASK = 8;
    public static final byte ARRAY_MASK = 16;
    public static final byte CHAR = 10;
    public static final byte NULL = 7;
    public static final byte STRING = 0;
    public static final byte OBJECT = 5;
    public static final byte SEQUENCE = 6;
    public static final byte DOUBLE = 2;
    public static final byte DOUBLE_ARR = 3;
    public static final byte FLOAT = 1;
    public static final byte FLOAT_ARR = 4;
    public static final byte BOOL = 8;
    public static final byte HANDLE = 9;
    HashMap<Class, TagSerializer> clz2Ser = new HashMap();
    TagSerializer[] tag2Ser = new TagSerializer[32];
    int tagCount = 0;
    private TagSerializer nullTagSer = new MBTags.NullTagSer();

    public static boolean isPrimitive(byte type) {
        return (type & 7) < 5;
    }

    public static boolean isTag(byte type) {
        return (type & 7) == 5;
    }

    public static byte getTagId(byte type) {
        return (byte)(type >>> 3);
    }

    public static byte getTagCode(byte tagId) {
        return (byte)(tagId << 3 | 5);
    }

    public static boolean isSigned(byte type) {
        return (type & 7) < 5 && (type & 8) == 0;
    }

    public static boolean isArray(byte type) {
        return (type & 7) < 5 && (type & 0x10) != 0;
    }

    public static byte extractNumBytes(byte type) {
        return (byte)(1 << (type & 7) - 1);
    }

    public MinBin() {
        this.registerTag(new MBTags.StringTagSer());
        this.registerTag(new MBTags.FloatTagSer());
        this.registerTag(new MBTags.DoubleTagSer());
        this.registerTag(new MBTags.DoubleArrTagSer());
        this.registerTag(new MBTags.FloatArrTagSer());
        this.registerTag(new MBTags.MBObjectTagSer());
        this.registerTag(new MBTags.MBSequenceTagSer());
        this.registerTag(this.nullTagSer);
        this.registerTag(new MBTags.BigBoolTagSer());
        this.registerTag(new MBTags.RefTagSer());
    }

    public static void print(byte[] minbinMsg) {
        MBPrinter.printMessage(minbinMsg, System.out);
    }

    public static String print2String(byte[] minbinMsg) {
        return MBPrinter.print2String(minbinMsg);
    }

    public static void print(Object obj) {
        MBPrinter.printMessage(obj, System.out);
    }

    public void registerTag(TagSerializer ts) {
        this.registerTag(ts.getClassEncoded(), ts);
    }

    public void registerTag(Class clazz, TagSerializer ts) {
        ts.setTagId(this.tagCount++);
        if (clazz != null) {
            this.clz2Ser.put(clazz, ts);
        }
        this.tag2Ser[ts.getTagId()] = ts;
    }

    public TagSerializer getSerializerForId(int tagId) {
        return this.tag2Ser[tagId];
    }

    public TagSerializer getSerializerFor(Object toWrite) {
        if (toWrite == null) {
            return this.nullTagSer;
        }
        return this.clz2Ser.get(toWrite.getClass());
    }

    public static byte getBaseType(byte type) {
        return (byte)(type & 7 | type & 8);
    }

    public static abstract class TagSerializer {
        int tagId;

        public int getTagId() {
            return this.tagId;
        }

        public void setTagId(int tagId) {
            this.tagId = tagId;
        }

        public abstract void writeTag(Object var1, MBOut var2);

        public abstract Object readTag(MBIn var1);

        public abstract Class getClassEncoded();
    }
}

