/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.util.FSTUtil;

public class FSTCollectionSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Collection col = (Collection)toWrite;
        int size = col.size();
        out.writeInt(size);
        Class<?> lastClz = null;
        FSTClazzInfo lastInfo = null;
        if (col.getClass() == ArrayList.class) {
            List l = (List)col;
            for (int i = 0; i < size; ++i) {
                Object o = l.get(i);
                if (o != null) {
                    lastInfo = out.writeObjectInternal(o, o.getClass() == lastClz ? lastInfo : null, null);
                    lastClz = o.getClass();
                    continue;
                }
                out.writeObjectInternal(o, null, null);
            }
        } else {
            for (Object o : col) {
                if (o != null) {
                    lastInfo = out.writeObjectInternal(o, o.getClass() == lastClz ? lastInfo : null, null);
                    lastClz = o.getClass();
                    continue;
                }
                out.writeObjectInternal(o, null, null);
            }
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        try {
            AbstractCollection res = null;
            int len = in.readInt();
            res = objectClass == ArrayList.class ? new ArrayList(len) : (objectClass == HashSet.class ? new HashSet(len) : (objectClass == Vector.class ? new Vector(len) : (objectClass == LinkedList.class ? new LinkedList() : (AbstractList.class.isAssignableFrom(objectClass) && objectClass.getName().startsWith("java.util.Arrays") ? new ArrayList() : objectClass.newInstance()))));
            in.registerObject(res, streamPosition, serializationInfo, referencee);
            Collection col = res;
            if (col instanceof ArrayList) {
                ((ArrayList)col).ensureCapacity(len);
            }
            for (int i = 0; i < len; ++i) {
                Object o = in.readObjectInternal(null);
                col.add(o);
            }
            return res;
        }
        catch (Throwable th) {
            FSTUtil.rethrow(th);
            return null;
        }
    }
}

