/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.magic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.commit.AbstractS3ACommitter;
import org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.impl.CommitContext;
import org.apache.hadoop.fs.s3a.commit.impl.CommitOperations;
import org.apache.hadoop.fs.s3a.commit.impl.CommitUtilsWithMR;
import org.apache.hadoop.fs.s3a.commit.magic.InMemoryMagicCommitTracker;
import org.apache.hadoop.fs.s3a.commit.magic.MagicCommitTrackerUtils;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.DurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MagicS3GuardCommitter
extends AbstractS3ACommitter {
    private static final Logger LOG = LoggerFactory.getLogger(MagicS3GuardCommitter.class);
    public static final String NAME = "magic";

    public MagicS3GuardCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.setWorkPath(this.getTaskAttemptPath(context));
        CommitUtils.verifyIsMagicCommitPath(this.getDestS3AFS(), this.getWorkPath());
        LOG.debug("Task attempt {} has work path {}", (Object)context.getTaskAttemptID(), (Object)this.getWorkPath());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected boolean requiresDelayedCommitOutputInFileSystem() {
        return true;
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Setup Job %s", new Object[]{CommitUtilsWithMR.jobIdString(context)});){
            super.setupJob(context);
            Path jobPath = this.getJobPath();
            FileSystem destFS = this.getDestinationFS(jobPath, context.getConfiguration());
            destFS.mkdirs(jobPath);
        }
    }

    @Override
    protected AbstractS3ACommitter.ActiveCommit listPendingUploadsToCommit(CommitContext commitContext) throws IOException {
        FileSystem fs = this.getDestFS();
        return AbstractS3ACommitter.ActiveCommit.fromStatusIterator(fs, S3AUtils.listAndFilter(fs, this.getJobAttemptPath(commitContext.getJobContext()), false, CommitOperations.PENDINGSET_FILTER));
    }

    @Override
    public void cleanupStagingDirs() {
        if (MagicCommitTrackerUtils.isCleanupMagicCommitterEnabled(this.getConf())) {
            Path out = this.getOutputPath();
            Path path = CommitUtilsWithMR.getMagicJobPath(this.getUUID(), out);
            try (DurationInfo ignored = new DurationInfo(LOG, true, "Deleting magic directory %s", new Object[]{path});){
                Invoker.ignoreIOExceptions(LOG, "cleanup magic directory", path.toString(), () -> S3AUtils.deleteWithWarning(this.getDestFS(), path, true));
                Invoker.ignoreIOExceptions(LOG, "cleanup job directory", path.toString(), () -> S3AUtils.deleteWithWarning(this.getDestFS(), new Path(out, "_temporary"), true));
            }
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return true;
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Commit task %s", new Object[]{context.getTaskAttemptID()});){
            PendingSet commits = this.innerCommitTask(context);
            LOG.info("Task {} committed {} files", (Object)context.getTaskAttemptID(), (Object)commits.size());
        }
        catch (IOException e) {
            this.getCommitOperations().taskCompleted(false);
            throw e;
        }
        finally {
            this.deleteTaskAttemptPathQuietly(context);
        }
        this.getCommitOperations().taskCompleted(true);
        LOG.debug("aggregate statistics\n{}", IOStatisticsLogging.demandStringifyIOStatistics((IOStatistics)this.getIOStatistics()));
    }

    private PendingSet innerCommitTask(TaskAttemptContext context) throws IOException {
        PendingSet pendingSet = this.loadPendingCommits(context);
        try (CommitContext commitContext = this.initiateTaskOperation((JobContext)context);){
            String jobId = this.getUUID();
            String taskId = String.valueOf(context.getTaskAttemptID());
            for (SinglePendingCommit commit : pendingSet.getCommits()) {
                commit.setJobId(jobId);
                commit.setTaskId(taskId);
            }
            pendingSet.putExtraData("task.attempt.id", taskId);
            pendingSet.setJobId(jobId);
            if (commitContext.isCollectIOStatistics()) {
                pendingSet.getIOStatistics().aggregate(commitContext.getIOStatisticsContext().getIOStatistics());
            }
            Path jobAttemptPath = this.getJobAttemptPath((JobContext)context);
            TaskAttemptID taskAttemptID = context.getTaskAttemptID();
            Path taskOutcomePath = new Path(jobAttemptPath, taskAttemptID.getTaskID().toString() + ".pendingset");
            LOG.info("Saving work of {} to {}", (Object)taskAttemptID, (Object)taskOutcomePath);
            LOG.debug("task statistics\n{}", IOStatisticsLogging.demandStringifyIOStatisticsSource((IOStatisticsSource)pendingSet));
            try {
                pendingSet.save(this.getDestFS(), taskOutcomePath, commitContext.getPendingSetSerializer());
            }
            catch (IOException e) {
                LOG.warn("Failed to save task commit data to {} ", (Object)taskOutcomePath, (Object)e);
                this.abortPendingUploads(commitContext, pendingSet.getCommits(), true);
                throw e;
            }
        }
        return pendingSet;
    }

    protected PendingSet loadPendingCommits(TaskAttemptContext context) throws IOException {
        PendingSet pendingSet = new PendingSet();
        if (MagicCommitTrackerUtils.isTrackMagicCommitsInMemoryEnabled(context.getConfiguration())) {
            List<SinglePendingCommit> pendingCommits = this.loadPendingCommitsFromMemory(context);
            for (SinglePendingCommit singleCommit : pendingCommits) {
                pendingSet.getIOStatistics().aggregate((IOStatistics)singleCommit.getIOStatistics());
                singleCommit.getIOStatistics().clear();
            }
            pendingSet.setCommits(pendingCommits);
        } else {
            CommitOperations actions = this.getCommitOperations();
            Path taskAttemptPath = this.getTaskAttemptPath(context);
            try (CommitContext commitContext = this.initiateTaskOperation((JobContext)context);){
                Pair<PendingSet, List<Pair<LocatedFileStatus, IOException>>> loaded = actions.loadSinglePendingCommits(taskAttemptPath, true, commitContext);
                pendingSet = (PendingSet)loaded.getKey();
                List failures = (List)loaded.getValue();
                if (!failures.isEmpty()) {
                    LOG.error("At least one commit file could not be read: failing");
                    this.abortPendingUploads(commitContext, pendingSet.getCommits(), true);
                    throw (IOException)((Pair)failures.get(0)).getValue();
                }
            }
        }
        return pendingSet;
    }

    private List<SinglePendingCommit> loadPendingCommitsFromMemory(TaskAttemptContext context) {
        String taskAttemptId = String.valueOf(context.getTaskAttemptID());
        List<SinglePendingCommit> pendingCommits = InMemoryMagicCommitTracker.getTaskAttemptIdToMpuMetadata().remove(taskAttemptId);
        List<Path> pathsAssociatedWithTaskAttemptId = InMemoryMagicCommitTracker.getTaskAttemptIdToPath().remove(taskAttemptId);
        if (pathsAssociatedWithTaskAttemptId != null) {
            for (Path path : pathsAssociatedWithTaskAttemptId) {
                boolean cleared = InMemoryMagicCommitTracker.getPathToBytesWritten().remove(path) != null;
                LOG.debug("Removing path: {} from the memory isSuccess: {}", (Object)path, (Object)cleared);
            }
        } else {
            LOG.debug("No paths to remove for taskAttemptId: {}", (Object)taskAttemptId);
        }
        if (pendingCommits == null || pendingCommits.isEmpty()) {
            LOG.info("No commit data present for the taskAttemptId: {} in the memory", (Object)taskAttemptId);
            return new ArrayList<SinglePendingCommit>();
        }
        return pendingCommits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTask(TaskAttemptContext context) throws IOException {
        Path attemptPath = this.getTaskAttemptPath(context);
        try (DurationInfo d = new DurationInfo(LOG, "Abort task %s", new Object[]{context.getTaskAttemptID()});
             CommitContext commitContext = this.initiateTaskOperation((JobContext)context);){
            if (MagicCommitTrackerUtils.isTrackMagicCommitsInMemoryEnabled(context.getConfiguration())) {
                List<SinglePendingCommit> pendingCommits = this.loadPendingCommitsFromMemory(context);
                for (SinglePendingCommit singleCommit : pendingCommits) {
                    commitContext.abortSingleCommit(singleCommit);
                }
            } else {
                this.getCommitOperations().abortAllSinglePendingCommits(attemptPath, commitContext, true);
            }
        }
        finally {
            S3AUtils.deleteQuietly(attemptPath.getFileSystem(context.getConfiguration()), attemptPath, true);
        }
    }

    @Override
    protected Path getJobPath() {
        return CommitUtilsWithMR.getMagicJobPath(this.getUUID(), this.getOutputPath());
    }

    @Override
    protected final Path getJobAttemptPath(int appAttemptId) {
        return CommitUtilsWithMR.getMagicJobAttemptPath(this.getUUID(), appAttemptId, this.getOutputPath());
    }

    @Override
    public final Path getTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getMagicTaskAttemptPath(context, this.getUUID(), this.getOutputPath());
    }

    @Override
    protected final Path getBaseTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getBaseMagicTaskAttemptPath(context, this.getUUID(), this.getOutputPath());
    }

    @Override
    public Path getTempTaskAttemptPath(TaskAttemptContext context) {
        return CommitUtilsWithMR.getTempTaskAttemptPath(context, this.getUUID(), this.getOutputPath());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MagicCommitter{");
        sb.append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}

