/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.JsonSerialization;
import org.junit.Test;

public class TestJsonSerialization
extends HadoopTestBase {
    private final JsonSerialization<KeyVal> serDeser = new JsonSerialization(KeyVal.class, true, true);
    private final KeyVal source = new KeyVal("key", "1");

    @Test
    public void testStringRoundTrip() throws Throwable {
        String wire = this.serDeser.toJson((Object)this.source);
        KeyVal unmarshalled = (KeyVal)this.serDeser.fromJson(wire);
        TestJsonSerialization.assertEquals((String)("Failed to unmarshall: " + wire), (Object)this.source, (Object)unmarshalled);
    }

    @Test
    public void testBytesRoundTrip() throws Throwable {
        byte[] wire = this.serDeser.toBytes((Object)this.source);
        KeyVal unmarshalled = (KeyVal)this.serDeser.fromBytes(wire);
        TestJsonSerialization.assertEquals((Object)this.source, (Object)unmarshalled);
    }

    @Test
    public void testBadBytesRoundTrip() throws Throwable {
        LambdaTestUtils.intercept(JsonParseException.class, "token", () -> (KeyVal)this.serDeser.fromBytes(new byte[]{97}));
    }

    @Test
    public void testCloneViaJson() throws Throwable {
        KeyVal unmarshalled = (KeyVal)this.serDeser.fromInstance((Object)this.source);
        TestJsonSerialization.assertEquals((Object)this.source, (Object)unmarshalled);
    }

    @Test
    public void testFileRoundTrip() throws Throwable {
        File tempFile = File.createTempFile("Keyval", ".json");
        tempFile.delete();
        try {
            this.serDeser.save(tempFile, (Object)this.source);
            TestJsonSerialization.assertEquals((Object)this.source, (Object)this.serDeser.load(tempFile));
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testEmptyFile() throws Throwable {
        File tempFile = File.createTempFile("Keyval", ".json");
        try {
            LambdaTestUtils.intercept(EOFException.class, "empty", () -> (KeyVal)this.serDeser.load(tempFile));
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemRoundTrip() throws Throwable {
        File tempFile = File.createTempFile("Keyval", ".json");
        tempFile.delete();
        Path tempPath = new Path(tempFile.toURI());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        try {
            this.serDeser.save((FileSystem)fs, tempPath, (Object)this.source, false);
            TestJsonSerialization.assertEquals((String)"JSON loaded with load(fs, path)", (Object)this.source, (Object)this.serDeser.load((FileSystem)fs, tempPath));
            TestJsonSerialization.assertEquals((String)"JSON loaded with load(fs, path, status)", (Object)this.source, (Object)this.serDeser.load((FileSystem)fs, tempPath, fs.getFileStatus(tempPath)));
        }
        finally {
            fs.delete(tempPath, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemEmptyPath() throws Throwable {
        File tempFile = File.createTempFile("Keyval", ".json");
        Path tempPath = new Path(tempFile.toURI());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        try {
            LambdaTestUtils.intercept(PathIOException.class, () -> (KeyVal)this.serDeser.load((FileSystem)fs, tempPath));
            fs.delete(tempPath, false);
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> (KeyVal)this.serDeser.load((FileSystem)fs, tempPath));
        }
        finally {
            fs.delete(tempPath, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemEmptyStatus() throws Throwable {
        File tempFile = File.createTempFile("Keyval", ".json");
        Path tempPath = new Path(tempFile.toURI());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        try {
            FileStatus st = fs.getFileStatus(tempPath);
            LambdaTestUtils.intercept(EOFException.class, () -> (KeyVal)this.serDeser.load((FileSystem)fs, tempPath, st));
        }
        finally {
            fs.delete(tempPath, false);
        }
    }

    private static class KeyVal
    implements Serializable {
        private String name;
        private String value;

        KeyVal(String name, String value) {
            this.name = name;
            this.value = value;
        }

        KeyVal() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SimpleJson{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", value='").append(this.value).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyVal that = (KeyVal)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

