/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import org.apache.hadoop.tools.rumen.Node;
import org.apache.hadoop.tools.rumen.RackNode;

public final class MachineNode
extends Node {
    long memory = -1L;
    int mapSlots = 1;
    int reduceSlots = 1;
    long memoryPerMapSlot = -1L;
    long memoryPerReduceSlot = -1L;
    int numCores = 1;

    MachineNode(String name, int level) {
        super(name, level);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public long getMemory() {
        return this.memory;
    }

    public int getMapSlots() {
        return this.mapSlots;
    }

    public int getReduceSlots() {
        return this.reduceSlots;
    }

    public long getMemoryPerMapSlot() {
        return this.memoryPerMapSlot;
    }

    public long getMemoryPerReduceSlot() {
        return this.memoryPerReduceSlot;
    }

    public int getNumCores() {
        return this.numCores;
    }

    public RackNode getRackNode() {
        return (RackNode)this.getParent();
    }

    @Override
    public synchronized boolean addChild(Node child) {
        throw new IllegalStateException("Cannot add child to MachineNode");
    }

    public static final class Builder {
        private MachineNode node;

        public Builder(String name, int level) {
            this.node = new MachineNode(name, level);
        }

        public Builder setMemory(long memory) {
            this.node.memory = memory;
            return this;
        }

        public Builder setMapSlots(int mapSlots) {
            this.node.mapSlots = mapSlots;
            return this;
        }

        public Builder setReduceSlots(int reduceSlots) {
            this.node.reduceSlots = reduceSlots;
            return this;
        }

        public Builder setMemoryPerMapSlot(long memoryPerMapSlot) {
            this.node.memoryPerMapSlot = memoryPerMapSlot;
            return this;
        }

        public Builder setMemoryPerReduceSlot(long memoryPerReduceSlot) {
            this.node.memoryPerReduceSlot = memoryPerReduceSlot;
            return this;
        }

        public Builder setNumCores(int numCores) {
            this.node.numCores = numCores;
            return this;
        }

        public Builder cloneFrom(MachineNode ref) {
            this.node.memory = ref.memory;
            this.node.mapSlots = ref.mapSlots;
            this.node.reduceSlots = ref.reduceSlots;
            this.node.memoryPerMapSlot = ref.memoryPerMapSlot;
            this.node.memoryPerReduceSlot = ref.memoryPerReduceSlot;
            this.node.numCores = ref.numCores;
            return this;
        }

        public MachineNode build() {
            MachineNode retVal = this.node;
            this.node = null;
            return retVal;
        }
    }
}

