/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextMainOperationsBaseTest;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWebHdfsFileContextMainOperations
extends FileContextMainOperationsBaseTest {
    protected static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    protected static URI webhdfsUrl;
    protected static int numBlocks;
    protected static final byte[] data;
    protected static final HdfsConfiguration CONF;

    public Path getDefaultWorkingDirectory() {
        return defaultWorkingDirectory;
    }

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper();
    }

    public URI getWebhdfsUrl() {
        return webhdfsUrl;
    }

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException, LoginException, URISyntaxException {
        cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(2).build();
        cluster.waitClusterUp();
        webhdfsUrl = new URI("webhdfs://" + cluster.getConfiguration(0).get("dfs.namenode.http-address"));
        fc = FileContext.getFileContext((URI)webhdfsUrl, (Configuration)CONF);
        defaultWorkingDirectory = fc.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fc.mkdir(defaultWorkingDirectory, FileContext.DEFAULT_PERM, true);
    }

    @Before
    public void setUp() throws Exception {
        URI webhdfsUrlReal = this.getWebhdfsUrl();
        Path testBuildData = new Path(webhdfsUrlReal + "/" + "target/test/data/" + RandomStringUtils.randomAlphanumeric((int)10));
        Path rootPath = new Path(testBuildData, "root-uri");
        this.localFsRootPath = rootPath.makeQualified(webhdfsUrlReal, null);
        fc.mkdir(this.getTestRootPath(fc, "test"), FileContext.DEFAULT_PERM, true);
    }

    private Path getTestRootPath(FileContext fc, String path) {
        return this.fileContextTestHelper.getTestRootPath(fc, path);
    }

    protected boolean listCorruptedBlocksSupported() {
        return false;
    }

    @Test
    public void testUnsupportedSymlink() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetVerifyChecksum() throws IOException {
        Path rootPath = this.getTestRootPath(fc, "test");
        Path path = new Path(rootPath, "zoo");
        try (FSDataOutputStream out = fc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});){
            out.write(data, 0, data.length);
        }
        fc.setVerifyChecksum(true, path);
        FileStatus fileStatus = fc.getFileStatus(path);
        long len = fileStatus.getLen();
        Assert.assertTrue((len == (long)data.length ? 1 : 0) != 0);
        byte[] bb = new byte[(int)len];
        try (FSDataInputStream fsdis = fc.open(path);){
            fsdis.readFully(bb);
        }
        Assert.assertArrayEquals((byte[])data, (byte[])bb);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    static {
        numBlocks = 2;
        data = FileContextTestHelper.getFileData((int)numBlocks, (long)FileContextTestHelper.getDefaultBlockSize());
        CONF = new HdfsConfiguration();
    }
}

