/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestFileAppend3 {
    static final long BLOCK_SIZE = 65536L;
    static final short REPLICATION = 3;
    static final int DATANODE_NUM = 5;
    private static Configuration conf;
    private static int buffersize;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;

    public TestFileAppend3() {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DataNode.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)InterDatanodeProtocol.LOG, (Level)Level.TRACE);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        AppendTestUtil.LOG.info("setUp()");
        conf = new HdfsConfiguration();
        conf.setInt("dfs.bytes-per-checksum", 512);
        buffersize = conf.getInt("io.file.buffer.size", 4096);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(5).build();
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        AppendTestUtil.LOG.info("tearDown()");
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testTC1() throws Exception {
        Path p = new Path("/TC1/foo");
        System.out.println("p=" + p);
        int len1 = 65536;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 65536);
        out.close();
        int len2 = 32768;
        FSDataOutputStream out2 = fs.append(p);
        AppendTestUtil.write((OutputStream)out2, 65536, 32768);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 98304L);
    }

    @Test
    public void testTC1ForAppend2() throws Exception {
        Path p = new Path("/TC1/foo2");
        int len1 = 65536;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 65536);
        out.close();
        int len2 = 32768;
        FSDataOutputStream out2 = fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
        AppendTestUtil.write((OutputStream)out2, 65536, 32768);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 98304L);
    }

    @Test
    public void testTC2() throws Exception {
        Path p = new Path("/TC2/foo");
        System.out.println("p=" + p);
        int len1 = 98304;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 98304);
        out.close();
        AppendTestUtil.check((FileSystem)fs, p, 98304L);
        int len2 = 16384;
        FSDataOutputStream out2 = fs.append(p);
        AppendTestUtil.write((OutputStream)out2, 98304, 16384);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 114688L);
    }

    @Test
    public void testTC2ForAppend2() throws Exception {
        Path p = new Path("/TC2/foo2");
        int len1 = 98304;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 98304);
        out.close();
        AppendTestUtil.check((FileSystem)fs, p, 98304L);
        int len2 = 16384;
        FSDataOutputStream out2 = fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
        AppendTestUtil.write((OutputStream)out2, 98304, 16384);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 114688L);
        List blocks = fs.getClient().getLocatedBlocks(p.toString(), 0L).getLocatedBlocks();
        Assert.assertEquals((long)3L, (long)blocks.size());
        Assert.assertEquals((long)65536L, (long)((LocatedBlock)blocks.get(0)).getBlockSize());
        Assert.assertEquals((long)32768L, (long)((LocatedBlock)blocks.get(1)).getBlockSize());
        Assert.assertEquals((long)16384L, (long)((LocatedBlock)blocks.get(2)).getBlockSize());
    }

    @Test
    public void testTC5() throws Exception {
        Path p = new Path("/TC5/foo");
        System.out.println("p=" + p);
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 32768);
        out.close();
        out = fs.append(p);
        try {
            AppendTestUtil.createHdfsWithDifferentUsername(conf).append(p);
            Assert.fail((String)"This should fail.");
        }
        catch (IOException ioe) {
            AppendTestUtil.LOG.info("GOOD: got an exception", (Throwable)ioe);
        }
        try {
            ((DistributedFileSystem)AppendTestUtil.createHdfsWithDifferentUsername(conf)).append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
            Assert.fail((String)"This should fail.");
        }
        catch (IOException ioe) {
            AppendTestUtil.LOG.info("GOOD: got an exception", (Throwable)ioe);
        }
        out.close();
    }

    @Test
    public void testTC5ForAppend2() throws Exception {
        Path p = new Path("/TC5/foo2");
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 32768);
        out.close();
        out = fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
        try {
            ((DistributedFileSystem)AppendTestUtil.createHdfsWithDifferentUsername(conf)).append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);
            Assert.fail((String)"This should fail.");
        }
        catch (IOException ioe) {
            AppendTestUtil.LOG.info("GOOD: got an exception", (Throwable)ioe);
        }
        try {
            AppendTestUtil.createHdfsWithDifferentUsername(conf).append(p);
            Assert.fail((String)"This should fail.");
        }
        catch (IOException ioe) {
            AppendTestUtil.LOG.info("GOOD: got an exception", (Throwable)ioe);
        }
        out.close();
    }

    private void testTC7(boolean appendToNewBlock) throws Exception {
        int repl = 2;
        Path p = new Path("/TC7/foo" + (appendToNewBlock ? "0" : "1"));
        System.out.println("p=" + p);
        int len1 = 32768;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)2, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 32768);
        out.close();
        DFSTestUtil.waitReplication((FileSystem)fs, p, (short)2);
        LocatedBlocks locatedblocks = TestFileAppend3.fs.dfs.getNamenode().getBlockLocations(p.toString(), 0L, 32768L);
        Assert.assertEquals((long)1L, (long)locatedblocks.locatedBlockCount());
        LocatedBlock lb = locatedblocks.get(0);
        ExtendedBlock blk = lb.getBlock();
        Assert.assertEquals((long)32768L, (long)lb.getBlockSize());
        DatanodeInfoWithStorage[] datanodeinfos = lb.getLocations();
        Assert.assertEquals((long)2L, (long)datanodeinfos.length);
        DataNode dn = cluster.getDataNode(datanodeinfos[0].getIpcPort());
        cluster.getMaterializedReplica(dn, blk).truncateData(0L);
        int len2 = 65536;
        FSDataOutputStream out2 = appendToNewBlock ? fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null) : fs.append(p);
        AppendTestUtil.write((OutputStream)out2, 32768, 65536);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 98304L);
    }

    @Test
    public void testTC7() throws Exception {
        this.testTC7(false);
    }

    @Test
    public void testTC7ForAppend2() throws Exception {
        this.testTC7(true);
    }

    private void testTC11(boolean appendToNewBlock) throws Exception {
        Path p = new Path("/TC11/foo" + (appendToNewBlock ? "0" : "1"));
        System.out.println("p=" + p);
        int len1 = 65536;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 65536);
        out.close();
        out = appendToNewBlock ? fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null) : fs.append(p);
        int len2 = 32768;
        AppendTestUtil.write((OutputStream)out, 65536, 32768);
        out.hflush();
        Path pnew = new Path(p + ".new");
        Assert.assertTrue((boolean)fs.rename(p, pnew));
        out.close();
        long len = fs.getFileStatus(pnew).getLen();
        LocatedBlocks locatedblocks = TestFileAppend3.fs.dfs.getNamenode().getBlockLocations(pnew.toString(), 0L, len);
        int numblock = locatedblocks.locatedBlockCount();
        for (int i = 0; i < numblock; ++i) {
            LocatedBlock lb = locatedblocks.get(i);
            ExtendedBlock blk = lb.getBlock();
            long size = lb.getBlockSize();
            if (i < numblock - 1) {
                Assert.assertEquals((long)65536L, (long)size);
            }
            for (DatanodeInfoWithStorage datanodeinfo : lb.getLocations()) {
                DataNode dn = cluster.getDataNode(datanodeinfo.getIpcPort());
                Block metainfo = DataNodeTestUtils.getFSDataset(dn).getStoredBlock(blk.getBlockPoolId(), blk.getBlockId());
                Assert.assertEquals((long)size, (long)metainfo.getNumBytes());
            }
        }
    }

    @Test
    public void testTC11() throws Exception {
        this.testTC11(false);
    }

    @Test
    public void testTC11ForAppend2() throws Exception {
        this.testTC11(true);
    }

    private void testTC12(boolean appendToNewBlock) throws Exception {
        Path p = new Path("/TC12/foo" + (appendToNewBlock ? "0" : "1"));
        System.out.println("p=" + p);
        int len1 = 25687;
        FSDataOutputStream out = fs.create(p, false, buffersize, (short)3, 65536L);
        AppendTestUtil.write((OutputStream)out, 0, 25687);
        out.close();
        int len2 = 5877;
        FSDataOutputStream out2 = appendToNewBlock ? fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null) : fs.append(p);
        AppendTestUtil.write((OutputStream)out2, 25687, 5877);
        out2.close();
        AppendTestUtil.check((FileSystem)fs, p, 31564L);
        if (appendToNewBlock) {
            LocatedBlocks blks = TestFileAppend3.fs.dfs.getLocatedBlocks(p.toString(), 0L);
            Assert.assertEquals((long)2L, (long)blks.getLocatedBlocks().size());
            Assert.assertEquals((long)25687L, (long)((LocatedBlock)blks.getLocatedBlocks().get(0)).getBlockSize());
            Assert.assertEquals((long)5877L, (long)((LocatedBlock)blks.getLocatedBlocks().get(1)).getBlockSize());
            AppendTestUtil.check(fs, p, 0, 25687);
            AppendTestUtil.check(fs, p, 25687, 5877);
        }
    }

    @Test
    public void testTC12() throws Exception {
        this.testTC12(false);
    }

    @Test
    public void testTC12ForAppend2() throws Exception {
        this.testTC12(true);
    }

    private void testAppendToPartialChunk(boolean appendToNewBlock) throws IOException {
        Path p = new Path("/partialChunk/foo" + (appendToNewBlock ? "0" : "1"));
        int fileLen = 513;
        System.out.println("p=" + p);
        byte[] fileContents = AppendTestUtil.initBuffer(513);
        FSDataOutputStream stm = AppendTestUtil.createFile((FileSystem)fs, p, 1);
        stm.write(fileContents, 0, 1);
        stm.close();
        System.out.println("Wrote 1 byte and closed the file " + p);
        stm = appendToNewBlock ? fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null) : fs.append(p);
        stm.write(fileContents, 1, 1);
        stm.hflush();
        stm.close();
        System.out.println("Append 1 byte and closed the file " + p);
        stm = appendToNewBlock ? fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null) : fs.append(p);
        Assert.assertEquals((long)2L, (long)stm.getPos());
        stm.write(fileContents, 2, 1);
        stm.hflush();
        System.out.println("Append and flush 1 byte");
        stm.write(fileContents, 3, 2);
        stm.hflush();
        System.out.println("Append and flush 2 byte");
        stm.write(fileContents, 5, 508);
        stm.close();
        System.out.println("Flush 508 byte and closed the file " + p);
        AppendTestUtil.checkFullFile((FileSystem)fs, p, 513, fileContents, "Failed to append to a partial chunk");
    }

    void doSmallAppends(Path file, DistributedFileSystem fs, int iterations) throws IOException {
        for (int i = 0; i < iterations; ++i) {
            FSDataOutputStream stm;
            try {
                stm = fs.append(file);
            }
            catch (IOException e) {
                continue;
            }
            AppendTestUtil.write((OutputStream)stm, 0, 123);
            stm.close();
        }
    }

    @Test
    public void testSmallAppendRace() throws Exception {
        final Path file = new Path("/testSmallAppendRace");
        final String fName = file.toUri().getPath();
        FSDataOutputStream stm = fs.create(file);
        AppendTestUtil.write((OutputStream)stm, 0, 123);
        stm.close();
        final DFSClient client = DFSClientAdapter.getDFSClient(fs);
        DFSClient spyClient = (DFSClient)Mockito.spy((Object)client);
        Mockito.when((Object)spyClient.getFileInfo(fName)).thenAnswer((Answer)new Answer<HdfsFileStatus>(){

            public HdfsFileStatus answer(InvocationOnMock invocation) {
                try {
                    HdfsFileStatus stat = client.getFileInfo(fName);
                    Thread.sleep(100L);
                    return stat;
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        DFSClientAdapter.setDFSClient(fs, spyClient);
        Thread worker1 = new Thread(){

            @Override
            public void run() {
                try {
                    TestFileAppend3.this.doSmallAppends(file, fs, 20);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread worker2 = new Thread(){

            @Override
            public void run() {
                try {
                    TestFileAppend3.this.doSmallAppends(file, fs, 20);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        worker1.start();
        worker2.start();
        this.doSmallAppends(file, fs, 20);
    }

    @Test
    public void testAppendToPartialChunk() throws IOException {
        this.testAppendToPartialChunk(false);
    }

    @Test
    public void testAppendToPartialChunkforAppend2() throws IOException {
        this.testAppendToPartialChunk(true);
    }
}

