/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.ViewDistributedFileSystem;
import org.apache.hadoop.hdfs.server.namenode.TestCacheDirectives;

public class TestCacheDirectivesWithViewDFS
extends TestCacheDirectives {
    @Override
    public DistributedFileSystem getDFS() throws IOException {
        Configuration conf = this.getConf();
        conf.set("fs.hdfs.impl", ViewDistributedFileSystem.class.getName());
        URI defaultFSURI = URI.create(conf.get("fs.defaultFS"));
        ConfigUtil.addLinkFallback((Configuration)conf, (String)defaultFSURI.getHost(), (URI)new Path(defaultFSURI.toString()).toUri());
        ConfigUtil.addLink((Configuration)conf, (String)defaultFSURI.getHost(), (String)"/tmp", (URI)new Path(defaultFSURI.toString()).toUri());
        return super.getDFS();
    }

    @Override
    public DistributedFileSystem getDFS(MiniDFSCluster cluster, int nnIdx) throws IOException {
        Configuration conf = cluster.getConfiguration(nnIdx);
        conf.set("fs.hdfs.impl", ViewDistributedFileSystem.class.getName());
        URI uri = cluster.getURI(0);
        ConfigUtil.addLinkFallback((Configuration)conf, (String)uri.getHost(), (URI)uri);
        ConfigUtil.addLink((Configuration)conf, (String)uri.getHost(), (String)"/tmp", (URI)uri);
        return cluster.getFileSystem(0);
    }
}

