/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.router.RouterHDFSContract;
import org.apache.hadoop.fs.contract.router.SecurityConfUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.metrics.RouterMBean;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestRouterHDFSContractDelegationToken
extends AbstractFSContractTestBase {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @BeforeClass
    public static void createCluster() throws Exception {
        RouterHDFSContract.createCluster(false, 1, true);
    }

    @AfterClass
    public static void teardownCluster() throws IOException {
        RouterHDFSContract.destroyCluster();
    }

    protected AbstractFSContract createContract(Configuration conf) {
        return new RouterHDFSContract(conf);
    }

    @Test
    public void testRouterDelegationToken() throws Exception {
        RouterMBean bean = FederationTestUtils.getBean("Hadoop:service=Router,name=Router", RouterMBean.class);
        TestRouterHDFSContractDelegationToken.assertEquals((long)0L, (long)bean.getCurrentTokensCount());
        Token token = this.getFileSystem().getDelegationToken("router");
        TestRouterHDFSContractDelegationToken.assertNotNull((Object)token);
        TestRouterHDFSContractDelegationToken.assertEquals((Object)"HDFS_DELEGATION_TOKEN", (Object)token.getKind().toString());
        DelegationTokenIdentifier identifier = (DelegationTokenIdentifier)token.decodeIdentifier();
        TestRouterHDFSContractDelegationToken.assertNotNull((Object)identifier);
        String owner = identifier.getOwner().toString();
        String host = Path.WINDOWS ? "127.0.0.1" : "localhost";
        String expectedOwner = "router/" + host + "@EXAMPLE.COM";
        TestRouterHDFSContractDelegationToken.assertEquals((Object)expectedOwner, (Object)owner);
        TestRouterHDFSContractDelegationToken.assertEquals((Object)"router", (Object)identifier.getRenewer().toString());
        int masterKeyId = identifier.getMasterKeyId();
        TestRouterHDFSContractDelegationToken.assertTrue((masterKeyId > 0 ? 1 : 0) != 0);
        int sequenceNumber = identifier.getSequenceNumber();
        TestRouterHDFSContractDelegationToken.assertTrue((sequenceNumber > 0 ? 1 : 0) != 0);
        long existingMaxTime = ((DelegationTokenIdentifier)token.decodeIdentifier()).getMaxDate();
        TestRouterHDFSContractDelegationToken.assertTrue((identifier.getMaxDate() >= identifier.getIssueDate() ? 1 : 0) != 0);
        TestRouterHDFSContractDelegationToken.assertEquals((long)1L, (long)bean.getCurrentTokensCount());
        long expiryTime = token.renew(SecurityConfUtil.initSecurity());
        TestRouterHDFSContractDelegationToken.assertNotNull((Object)token);
        TestRouterHDFSContractDelegationToken.assertEquals((long)existingMaxTime, (long)((DelegationTokenIdentifier)token.decodeIdentifier()).getMaxDate());
        TestRouterHDFSContractDelegationToken.assertTrue((expiryTime <= existingMaxTime ? 1 : 0) != 0);
        identifier = (DelegationTokenIdentifier)token.decodeIdentifier();
        TestRouterHDFSContractDelegationToken.assertEquals((long)identifier.getMasterKeyId(), (long)masterKeyId);
        TestRouterHDFSContractDelegationToken.assertEquals((long)identifier.getSequenceNumber(), (long)sequenceNumber);
        TestRouterHDFSContractDelegationToken.assertEquals((long)1L, (long)bean.getCurrentTokensCount());
        token.cancel(SecurityConfUtil.initSecurity());
        TestRouterHDFSContractDelegationToken.assertEquals((long)0L, (long)bean.getCurrentTokensCount());
        this.exceptionRule.expect(SecretManager.InvalidToken.class);
        token.renew(SecurityConfUtil.initSecurity());
    }
}

