/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.http.server.HttpFSAuthenticationFilter;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.ProxyUserAuthenticationFilterInitializer;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HttpFSServerWebServer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpFSServerWebServer.class);
    private static final String HTTPFS_DEFAULT_XML = "httpfs-default.xml";
    private static final String HTTPFS_SITE_XML = "httpfs-site.xml";
    static final String HTTP_PORT_KEY = "httpfs.http.port";
    private static final int HTTP_PORT_DEFAULT = 14000;
    static final String HTTP_HOSTNAME_KEY = "httpfs.http.hostname";
    private static final String HTTP_HOSTNAME_DEFAULT = "0.0.0.0";
    static final String SSL_ENABLED_KEY = "httpfs.ssl.enabled";
    private static final boolean SSL_ENABLED_DEFAULT = false;
    private static final String HTTP_ADMINS_KEY = "httpfs.http.administrators";
    private static final String NAME = "webhdfs";
    private static final String SERVLET_PATH = "/webhdfs";
    private final HttpServer2 httpServer;
    private final String scheme;

    HttpFSServerWebServer(Configuration conf, Configuration sslConf) throws Exception {
        HttpFSServerWebServer.deprecateEnv("HTTPFS_HTTP_HOSTNAME", conf, HTTP_HOSTNAME_KEY, HTTPFS_SITE_XML);
        HttpFSServerWebServer.deprecateEnv("HTTPFS_HTTP_PORT", conf, HTTP_PORT_KEY, HTTPFS_SITE_XML);
        HttpFSServerWebServer.deprecateEnv("HTTPFS_MAX_THREADS", conf, "hadoop.http.max.threads", HTTPFS_SITE_XML);
        HttpFSServerWebServer.deprecateEnv("HTTPFS_MAX_HTTP_HEADER_SIZE", conf, "hadoop.http.max.request.header.size", HTTPFS_SITE_XML);
        HttpFSServerWebServer.deprecateEnv("HTTPFS_MAX_HTTP_HEADER_SIZE", conf, "hadoop.http.max.response.header.size", HTTPFS_SITE_XML);
        HttpFSServerWebServer.deprecateEnv("HTTPFS_SSL_ENABLED", conf, SSL_ENABLED_KEY, HTTPFS_SITE_XML);
        HttpFSServerWebServer.deprecateEnv("HTTPFS_SSL_KEYSTORE_FILE", sslConf, "ssl.server.keystore.location", "ssl-server.xml");
        HttpFSServerWebServer.deprecateEnv("HTTPFS_SSL_KEYSTORE_PASS", sslConf, "ssl.server.keystore.password", "ssl-server.xml");
        boolean sslEnabled = conf.getBoolean(SSL_ENABLED_KEY, false);
        this.scheme = sslEnabled ? "https" : "http";
        String host = conf.get(HTTP_HOSTNAME_KEY, HTTP_HOSTNAME_DEFAULT);
        int port = conf.getInt(HTTP_PORT_KEY, 14000);
        URI endpoint = new URI(this.scheme, null, host, port, null, null, null);
        String configuredInitializers = conf.get("hadoop.http.filter.initializers");
        if (configuredInitializers != null) {
            String[] parts;
            LinkedHashSet<String> target = new LinkedHashSet<String>();
            for (String filterInitializer : parts = configuredInitializers.split(",")) {
                if (filterInitializer.equals(AuthenticationFilterInitializer.class.getName()) || filterInitializer.equals(ProxyUserAuthenticationFilterInitializer.class.getName())) continue;
                target.add(filterInitializer);
            }
            String actualInitializers = StringUtils.join(target, (String)",");
            conf.set("hadoop.http.filter.initializers", actualInitializers);
        }
        this.httpServer = new HttpServer2.Builder().setName(NAME).setConf(conf).setSSLConf(sslConf).setAuthFilterConfigurationPrefixes(HttpFSAuthenticationFilter.CONF_PREFIXES).setACL(new AccessControlList(conf.get(HTTP_ADMINS_KEY, " "))).addEndpoint(endpoint).build();
    }

    private static void deprecateEnv(String varName, Configuration conf, String propName, String confFile) {
        String value = System.getenv(varName);
        if (value == null) {
            return;
        }
        LOG.warn("Environment variable {} is deprecated and overriding property {}', please set the property in {} instead.", new Object[]{varName, propName, confFile});
        conf.set(propName, value, "environment variable " + varName);
    }

    public void start() throws IOException {
        DefaultMetricsSystem.initialize((String)"httpfs");
        this.httpServer.start();
    }

    public void join() throws InterruptedException {
        this.httpServer.join();
    }

    public void stop() throws Exception {
        this.httpServer.stop();
        DefaultMetricsSystem.shutdown();
    }

    public URL getUrl() {
        InetSocketAddress addr = this.httpServer.getConnectorAddress(0);
        if (null == addr) {
            return null;
        }
        try {
            return new URL(this.scheme, addr.getHostName(), addr.getPort(), SERVLET_PATH);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("It should never happen: " + ex.getMessage(), ex);
        }
    }

    @VisibleForTesting
    HttpServer2 getHttpServer() {
        return this.httpServer;
    }

    public static void main(String[] args) throws Exception {
        org.apache.hadoop.util.StringUtils.startupShutdownMessage(HttpFSServerWebServer.class, (String[])args, (Logger)LOG);
        Configuration conf = new Configuration(true);
        Configuration sslConf = SSLFactory.readSSLConfiguration((Configuration)conf, (SSLFactory.Mode)SSLFactory.Mode.SERVER);
        HttpFSServerWebServer webServer = new HttpFSServerWebServer(conf, sslConf);
        webServer.start();
        webServer.join();
    }

    public static void addDeprecatedKeys() {
        Configuration.addDeprecations((Configuration.DeprecationDelta[])new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("httpfs.authentication.kerberos.keytab", "hadoop.http.authentication.kerberos.keytab"), new Configuration.DeprecationDelta("httpfs.authentication.kerberos.principal", "hadoop.http.authentication.kerberos.principal"), new Configuration.DeprecationDelta("httpfs.authentication.signature.secret.file", "hadoop.http.authentication.signature.secret.file"), new Configuration.DeprecationDelta("httpfs.authentication.type", "hadoop.http.authentication.type")});
    }

    static {
        HttpFSServerWebServer.addDeprecatedKeys();
        Configuration.addDefaultResource((String)HTTPFS_DEFAULT_XML);
        Configuration.addDefaultResource((String)HTTPFS_SITE_XML);
    }
}

