/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.access.Mutate1D;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.blas.AMAX;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.scalar.Scalar;

abstract class ScalarArray<N extends Number>
extends ReferenceTypeArray<N> {
    protected ScalarArray(N[] data) {
        super(data);
    }

    @Override
    public final void axpy(double a, Mutate1D y) {
        AXPY.invoke((Mutate1D)y, (double)a, (Number[])this.data);
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke((Number[])this.data, (int)first, (int)limit, (int)step);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return ((Scalar)((Object)this.data[index])).isAbsolute();
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return ((NormedVectorSpace)((Object)this.data[index])).isSmall(comparedTo);
    }
}

