/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

final class ZeroStore<N extends Number>
extends FactoryStore<N> {
    private final N myNumberZero;
    private final Scalar<N> myScalarZero;

    ZeroStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myScalarZero = factory.scalar().zero();
        this.myNumberZero = this.myScalarZero.getNumber();
    }

    @Override
    public MatrixStore<N> add(MatrixStore<N> addend) {
        return addend;
    }

    @Override
    public MatrixStore<N> conjugate() {
        return new ZeroStore(this.physical(), this.getColDim(), this.getRowDim());
    }

    @Override
    public double doubleValue(long anInd) {
        return PrimitiveMath.ZERO;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInColumn(int col) {
        return this.getRowDim();
    }

    @Override
    public int firstInRow(int row) {
        return this.getColDim();
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.myNumberZero;
    }

    @Override
    public int limitOfColumn(int col) {
        return 0;
    }

    @Override
    public int limitOfRow(int row) {
        return 0;
    }

    @Override
    public ZeroStore<N> multiply(MatrixStore<N> right) {
        return new ZeroStore(this.physical(), this.getRowDim(), (int)(right.count() / (long)this.getColDim()));
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.myScalarZero;
    }

    @Override
    public MatrixStore<N> transpose() {
        return new ZeroStore(this.physical(), this.getColDim(), this.getRowDim());
    }

    @Override
    protected void addNonzerosTo(ElementsConsumer<N> consumer) {
    }
}

