/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationDynamicDefaultsPatcher;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.cluster.management.InternalInitException;
import org.apache.ignite.internal.cluster.management.network.messages.CancelInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.cluster.management.network.messages.CmgPrepareInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.InitCompleteMessage;
import org.apache.ignite.internal.cluster.management.network.messages.InitErrorMessage;
import org.apache.ignite.internal.cluster.management.network.messages.PrepareInitCompleteMessage;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.configuration.validation.ConfigurationDuplicatesValidator;
import org.apache.ignite.internal.configuration.validation.ConfigurationValidator;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ClusterInitializer {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterInitializer.class);
    private static final int INIT_MESSAGE_SEND_TIMEOUT_MILLIS = 10000;
    private final ClusterService clusterService;
    private final ConfigurationDynamicDefaultsPatcher configurationDynamicDefaultsPatcher;
    private final ConfigurationValidator clusterConfigurationValidator;
    private final CmgMessagesFactory msgFactory = new CmgMessagesFactory();
    private final NodeProperties nodeProperties;

    public ClusterInitializer(ClusterService clusterService, ConfigurationDynamicDefaultsPatcher configurationDynamicDefaultsPatcher, ConfigurationValidator clusterConfigurationValidator, NodeProperties nodeProperties) {
        this.clusterService = clusterService;
        this.configurationDynamicDefaultsPatcher = configurationDynamicDefaultsPatcher;
        this.clusterConfigurationValidator = clusterConfigurationValidator;
        this.nodeProperties = nodeProperties;
    }

    public CompletableFuture<Void> initCluster(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName) {
        return this.initCluster(metaStorageNodeNames, cmgNodeNames, clusterName, null);
    }

    public CompletableFuture<Void> initCluster(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName, @Nullable String clusterConfiguration) {
        if (metaStorageNodeNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Meta Storage node names must not contain blank strings: " + String.valueOf(metaStorageNodeNames));
        }
        Set<String> msNodeNameSet = metaStorageNodeNames.stream().map(String::trim).collect(Collectors.toUnmodifiableSet());
        if (msNodeNameSet.size() != metaStorageNodeNames.size()) {
            throw new IllegalArgumentException("Meta Storage node names must not contain duplicates: " + String.valueOf(metaStorageNodeNames));
        }
        if (cmgNodeNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("CMG node names must not contain blank strings: " + String.valueOf(cmgNodeNames));
        }
        Set<String> cmgNodeNameSet = cmgNodeNames.stream().map(String::trim).collect(Collectors.toUnmodifiableSet());
        if (cmgNodeNameSet.size() != cmgNodeNames.size()) {
            throw new IllegalArgumentException("CMG node names must not contain duplicates: " + String.valueOf(metaStorageNodeNames));
        }
        if (msNodeNameSet.isEmpty() && cmgNodeNameSet.isEmpty()) {
            Collection clusterNodes = this.clusterService.topologyService().allMembers();
            int topologySize = clusterNodes.size();
            int msNodesLimit = topologySize < 5 ? 3 : 5;
            Set chosenNodes = clusterNodes.stream().map(InternalClusterNode::name).sorted().limit(msNodesLimit).collect(Collectors.toSet());
            msNodeNameSet = chosenNodes;
            cmgNodeNameSet = chosenNodes;
        } else if (msNodeNameSet.isEmpty()) {
            msNodeNameSet = cmgNodeNameSet;
        } else if (cmgNodeNames.isEmpty()) {
            cmgNodeNameSet = msNodeNameSet;
        }
        if (clusterName.isBlank()) {
            throw new IllegalArgumentException("Cluster name must not be empty");
        }
        try {
            Map<String, InternalClusterNode> nodesByConsistentId = this.getValidTopologySnapshot();
            List<InternalClusterNode> msNodes = ClusterInitializer.resolveNodes(nodesByConsistentId, msNodeNameSet);
            LOG.info("Resolved MetaStorage nodes[nodes={}]", new Object[]{msNodes});
            List<InternalClusterNode> cmgNodes = ClusterInitializer.resolveNodes(nodesByConsistentId, cmgNodeNameSet);
            LOG.info("Resolved CMG nodes[nodes={}]", new Object[]{cmgNodes});
            String patchedClusterConfiguration = this.patchClusterConfigurationWithDynamicDefaults(clusterConfiguration);
            this.validateConfiguration(patchedClusterConfiguration, clusterConfiguration);
            CmgPrepareInitMessage prepareInitMessage = this.msgFactory.cmgPrepareInitMessage().initInitiatorColocationEnabled(this.nodeProperties.colocationEnabled()).build();
            CmgInitMessage initMessage = this.msgFactory.cmgInitMessage().metaStorageNodes(msNodeNameSet).cmgNodes(cmgNodeNameSet).clusterName(clusterName).clusterId(UUID.randomUUID()).initialClusterConfiguration(patchedClusterConfiguration).build();
            return this.invokeMessage(cmgNodes, prepareInitMessage).thenCompose(ignored -> {
                LOG.info("CMG initialization preparation completed, going to send init message [initMessage={}].", new Object[]{initMessage});
                return ((CompletableFuture)this.invokeMessage(cmgNodes, initMessage).handle((v, e) -> {
                    if (e == null) {
                        LOG.info("Cluster initialized [clusterName={}, cmgNodes={}, msNodes={}]", new Object[]{initMessage.clusterName(), initMessage.cmgNodes(), initMessage.metaStorageNodes()});
                        return CompletableFutures.nullCompletedFuture();
                    }
                    if (e instanceof CompletionException) {
                        e = e.getCause();
                    }
                    LOG.warn("Initialization failed [reason={}]", e, new Object[]{e.getMessage()});
                    if (e instanceof InternalInitException && !((InternalInitException)((Object)((Object)((Object)e)))).shouldCancelInit()) {
                        return CompletableFuture.failedFuture(e);
                    }
                    LOG.debug("Critical error encountered, rolling back the init procedure", new Object[0]);
                    return this.cancelInit(cmgNodes, (Throwable)e);
                })).thenCompose(Function.identity());
            });
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private Map<String, InternalClusterNode> getValidTopologySnapshot() {
        HashMap<String, InternalClusterNode> result = new HashMap<String, InternalClusterNode>();
        this.clusterService.topologyService().allMembers().forEach(node -> {
            if (result.put(node.name(), (InternalClusterNode)node) != null) {
                LOG.error("Initialization failed, node \"{}\" has duplicate in the physical topology", new Object[]{node.name()});
                throw new InternalInitException(IgniteStringFormatter.format((String)"Duplicate node name \"{}\"", (Object[])new Object[]{node.name()}), true);
            }
        });
        return result;
    }

    private CompletableFuture<Void> cancelInit(Collection<InternalClusterNode> nodes, Throwable e) {
        CancelInitMessage cancelMessage = this.msgFactory.cancelInitMessage().reason(e.getMessage()).build();
        return ((CompletableFuture)this.sendMessage(nodes, cancelMessage).exceptionally(nestedEx -> {
            LOG.debug("Error when canceling init", nestedEx);
            e.addSuppressed((Throwable)nestedEx);
            return null;
        })).thenCompose(v -> CompletableFuture.failedFuture(e));
    }

    private CompletableFuture<Void> invokeMessage(Collection<InternalClusterNode> nodes, NetworkMessage message) {
        return ClusterInitializer.allOf(nodes, node -> this.clusterService.messagingService().invoke(node, message, 10000L).thenAccept(response -> {
            if (response instanceof InitErrorMessage) {
                InitErrorMessage errorResponse = (InitErrorMessage)response;
                LOG.warn("Got error response from node \"{}\": {}", new Object[]{node.name(), errorResponse.cause()});
                throw new InternalInitException(String.format("Initialization of node \"%s\" failed: %s", node.name(), errorResponse.cause()), errorResponse.shouldCancel());
            }
            if (!(response instanceof InitCompleteMessage) && !(response instanceof PrepareInitCompleteMessage)) {
                throw new InternalInitException(String.format("Unexpected response from node \"%s\": %s", node.name(), response.getClass()), true);
            }
        }));
    }

    private CompletableFuture<Void> sendMessage(Collection<InternalClusterNode> nodes, NetworkMessage message) {
        return ClusterInitializer.allOf(nodes, node -> this.clusterService.messagingService().send(node, message));
    }

    private static CompletableFuture<Void> allOf(Collection<InternalClusterNode> nodes, Function<InternalClusterNode, CompletableFuture<?>> futureProducer) {
        CompletableFuture[] futures = (CompletableFuture[])nodes.stream().map(futureProducer).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private static List<InternalClusterNode> resolveNodes(Map<String, InternalClusterNode> nodesByConsistentId, Collection<String> consistentIds) {
        return consistentIds.stream().map(consistentId -> {
            InternalClusterNode node = (InternalClusterNode)nodesByConsistentId.get(consistentId);
            if (node == null) {
                throw new IllegalArgumentException(String.format("Node \"%s\" is not present in the physical topology", consistentId));
            }
            return node;
        }).collect(Collectors.toList());
    }

    private String patchClusterConfigurationWithDynamicDefaults(@Nullable String hocon) {
        return this.configurationDynamicDefaultsPatcher.patchWithDynamicDefaults(hocon == null ? "" : hocon);
    }

    private void validateConfiguration(String patchedHocon, @Nullable String initialHocon) {
        List issues = this.clusterConfigurationValidator.validateHocon(patchedHocon);
        if (initialHocon != null) {
            issues.addAll(ConfigurationDuplicatesValidator.validate((String)initialHocon));
        }
        if (!issues.isEmpty()) {
            throw new ConfigurationValidationException((Collection)issues);
        }
    }
}

