/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.handlers;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.FuturesCleanupResult;
import org.apache.ignite.internal.partition.replicator.ReliableCatalogVersions;
import org.apache.ignite.internal.partition.replicator.ReplicaPrimacy;
import org.apache.ignite.internal.partition.replicator.ReplicaTableProcessor;
import org.apache.ignite.internal.partition.replicator.ReplicaTxFinishMarker;
import org.apache.ignite.internal.partition.replicator.ReplicationRaftCommandApplicator;
import org.apache.ignite.internal.partition.replicator.TableAwareReplicaRequestPreProcessor;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommandV2;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.service.RaftCommandRunner;
import org.apache.ignite.internal.replicator.CommandApplicationResult;
import org.apache.ignite.internal.replicator.ReplicaResult;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.ReplicatorRecoverableExceptions;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.TableWriteIntentSwitchReplicaRequest;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicaRequest;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicatedInfo;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class WriteIntentSwitchRequestHandler {
    private static final IgniteLogger LOG = Loggers.forClass(WriteIntentSwitchRequestHandler.class);
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final IntFunction<ReplicaTableProcessor> replicaListenerByTableId;
    private final ClockService clockService;
    private final ZonePartitionId replicationGroupId;
    private final TableAwareReplicaRequestPreProcessor tableAwareReplicaRequestPreProcessor;
    private final ReliableCatalogVersions reliableCatalogVersions;
    private final ReplicaTxFinishMarker txFinishMarker;
    private final ReplicationRaftCommandApplicator raftCommandApplicator;

    public WriteIntentSwitchRequestHandler(IntFunction<ReplicaTableProcessor> replicaListenerByTableId, ClockService clockService, SchemaSyncService schemaSyncService, CatalogService catalogService, TxManager txManager, RaftCommandRunner raftCommandRunner, ZonePartitionId replicationGroupId, TableAwareReplicaRequestPreProcessor tableAwareReplicaRequestPreProcessor) {
        this.replicaListenerByTableId = replicaListenerByTableId;
        this.clockService = clockService;
        this.replicationGroupId = replicationGroupId;
        this.tableAwareReplicaRequestPreProcessor = tableAwareReplicaRequestPreProcessor;
        this.reliableCatalogVersions = new ReliableCatalogVersions(schemaSyncService, catalogService);
        this.txFinishMarker = new ReplicaTxFinishMarker(txManager);
        this.raftCommandApplicator = new ReplicationRaftCommandApplicator(raftCommandRunner, (ReplicationGroupId)replicationGroupId);
    }

    public CompletableFuture<ReplicaResult> handle(WriteIntentSwitchReplicaRequest request, UUID senderId) {
        this.txFinishMarker.markFinished(request.txId(), request.commit() ? TxState.COMMITTED : TxState.ABORTED, request.commitTimestamp());
        List futures = request.tableIds().stream().map(tableId -> this.invokeTableWriteIntentSwitchReplicaRequest((int)tableId, request, this.clockService.current(), senderId)).collect(Collectors.toList());
        @Nullable HybridTimestamp commitTimestamp = request.commitTimestamp();
        HybridTimestamp commandTimestamp = commitTimestamp != null ? commitTimestamp : TransactionIds.beginTimestamp((UUID)request.txId());
        return CompletableFutures.allOf(futures).thenCompose(unused -> {
            boolean shouldApplyWiOnAnyTable = futures.stream().map(CompletableFuture::join).map(ReplicaResult::result).map(FuturesCleanupResult.class::cast).anyMatch(FuturesCleanupResult::shouldApplyWriteIntent);
            if (!shouldApplyWiOnAnyTable) {
                return CompletableFuture.completedFuture(new ReplicaResult((Object)this.writeIntentSwitchReplicationInfoFor(request), null));
            }
            return this.reliableCatalogVersions.safeReliableCatalogVersionFor(commandTimestamp).thenApply(catalogVersion -> {
                CompletionStage commandReplicatedFuture = this.applyCommandToGroup(request, (Integer)catalogVersion).thenApply(unused2 -> this.writeIntentSwitchReplicationInfoFor(request));
                return new ReplicaResult(null, new CommandApplicationResult(null, (CompletableFuture)commandReplicatedFuture));
            });
        });
    }

    private CompletableFuture<ReplicaResult> invokeTableWriteIntentSwitchReplicaRequest(int tableId, WriteIntentSwitchReplicaRequest request, HybridTimestamp now, UUID senderId) {
        TableWriteIntentSwitchReplicaRequest tableSpecificRequest = TX_MESSAGES_FACTORY.tableWriteIntentSwitchReplicaRequest().groupId(ReplicaMessageUtils.toReplicationGroupIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ReplicationGroupId)this.replicationGroupId)).timestamp(now).txId(request.txId()).commit(request.commit()).commitTimestamp(request.commitTimestamp()).tableId(tableId).build();
        return this.tableAwareReplicaRequestPreProcessor.preProcessTableAwareRequest((ReplicaRequest)tableSpecificRequest, ReplicaPrimacy.empty(), senderId).thenCompose(ignored -> this.replicaTableProcessor(tableId).process((ReplicaRequest)tableSpecificRequest, ReplicaPrimacy.empty(), senderId));
    }

    private CompletableFuture<Object> applyCommandToGroup(WriteIntentSwitchReplicaRequest request, Integer catalogVersion) {
        WriteIntentSwitchCommandV2 wiSwitchCmd = PARTITION_REPLICATION_MESSAGES_FACTORY.writeIntentSwitchCommandV2().txId(request.txId()).commit(request.commit()).commitTimestamp(request.commitTimestamp()).initiatorTime(this.clockService.current()).tableIds(request.tableIds()).requiredCatalogVersion(catalogVersion).build();
        return this.raftCommandApplicator.applyCommandWithExceptionHandling((Command)wiSwitchCmd).whenComplete((res, ex) -> {
            if (ex != null && !ReplicatorRecoverableExceptions.isRecoverable((Throwable)ex)) {
                LOG.warn("Failed to complete transaction cleanup command [txId=" + String.valueOf(request.txId()) + "]", ex);
            }
        });
    }

    private WriteIntentSwitchReplicatedInfo writeIntentSwitchReplicationInfoFor(WriteIntentSwitchReplicaRequest request) {
        return new WriteIntentSwitchReplicatedInfo(request.txId(), (ReplicationGroupId)this.replicationGroupId);
    }

    private ReplicaTableProcessor replicaTableProcessor(int tableId) {
        ReplicaTableProcessor replicaTableProcessor = this.replicaListenerByTableId.apply(tableId);
        assert (replicaTableProcessor != null) : "No replica table processor for table ID " + tableId;
        return replicaTableProcessor;
    }
}

