/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl;

import java.util.Objects;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.jetbrains.annotations.Nullable;

public class SessionInfo
implements CallInput {
    private final String nodeUrl;
    private final String nodeName;
    private final String jdbcUrl;
    private final String username;

    private SessionInfo(String nodeUrl, String nodeName, String jdbcUrl, @Nullable String username) {
        this.nodeUrl = nodeUrl;
        this.nodeName = nodeName;
        this.jdbcUrl = jdbcUrl;
        this.username = username;
    }

    public String nodeUrl() {
        return this.nodeUrl;
    }

    public String nodeName() {
        return this.nodeName;
    }

    public String jdbcUrl() {
        return this.jdbcUrl;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    public static SessionInfoBuilder builder() {
        return new SessionInfoBuilder();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionInfo that = (SessionInfo)o;
        return Objects.equals(this.nodeUrl, that.nodeUrl) && Objects.equals(this.nodeName, that.nodeName) && Objects.equals(this.jdbcUrl, that.jdbcUrl) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.nodeUrl);
        result = 31 * result + Objects.hashCode(this.nodeName);
        result = 31 * result + Objects.hashCode(this.jdbcUrl);
        result = 31 * result + Objects.hashCode(this.username);
        return result;
    }

    public static final class SessionInfoBuilder {
        private String nodeUrl;
        private String nodeName;
        private String jdbcUrl;
        private String username;

        private SessionInfoBuilder() {
        }

        public static SessionInfoBuilder builder() {
            return new SessionInfoBuilder();
        }

        public SessionInfoBuilder nodeUrl(String nodeUrl) {
            this.nodeUrl = nodeUrl;
            return this;
        }

        public SessionInfoBuilder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public SessionInfoBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public SessionInfoBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SessionInfo build() {
            return new SessionInfo(this.nodeUrl, this.nodeName, this.jdbcUrl, this.username);
        }
    }
}

