/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.recovery.system;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.api.recovery.system.MigrateRequest;
import org.apache.ignite3.internal.rest.api.recovery.system.ResetClusterRequest;

@Controller(value="/management/v1/recovery/cluster")
@Tags(value={@Tag(name="system"), @Tag(name="recovery")})
public interface SystemDisasterRecoveryApi {
    @Post(value="reset")
    @Operation(operationId="resetCluster", description="Initiates cluster reset to repair CMG/Metastorage group/both.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Cluster reset initiated."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public CompletableFuture<Void> reset(@Body ResetClusterRequest var1);

    @Post(value="migrate")
    @Operation(operationId="migrate", description="Migrates nodes from old cluster to new (repaired) cluster.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Migration initiated."), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    public CompletableFuture<Void> migrate(@Body MigrateRequest var1);
}

