/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class IncrementalSnapshotAwareMessage
extends GridCacheMessage {
    private static final long serialVersionUID = 0L;
    public static final short TYPE_CODE = 400;
    private GridCacheMessage payload;
    private UUID id;
    @Nullable
    private UUID txSnpId;
    private long topVer;

    public IncrementalSnapshotAwareMessage() {
    }

    public IncrementalSnapshotAwareMessage(GridCacheMessage payload, UUID id, @Nullable UUID txSnpId, long topVer) {
        this.payload = payload;
        this.id = id;
        this.txSnpId = txSnpId;
        this.topVer = topVer;
    }

    public UUID id() {
        return this.id;
    }

    public UUID txInrementalSnapshotId() {
        return this.txSnpId;
    }

    public GridCacheMessage payload() {
        return this.payload;
    }

    public long snapshotTopologyVersion() {
        return this.topVer;
    }

    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        this.payload.prepareMarshal(ctx);
    }

    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        this.payload.finishUnmarshal(ctx, ldr);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeUuid("id", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMessage("payload", this.payload)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeLong("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeUuid("txSnpId", this.txSnpId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.id = reader.readUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.payload = (GridCacheMessage)reader.readMessage("payload");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.topVer = reader.readLong("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.txSnpId = reader.readUuid("txSnpId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IncrementalSnapshotAwareMessage.class);
    }

    @Override
    public short directType() {
        return 400;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public int handlerId() {
        return 0;
    }

    @Override
    public boolean cacheGroupMessage() {
        return false;
    }
}

