/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheEntryQueryCursor;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryResponse;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.lang.IgniteBiPredicate;

public class ClientCacheScanQueryRequest
extends ClientCacheQueryRequest
implements ClientTxAwareRequest {
    private final boolean loc;
    private final int pageSize;
    private final Integer part;
    private final byte filterPlatform;
    private final Object filterObj;

    public ClientCacheScanQueryRequest(BinaryRawReaderEx reader) {
        super(reader);
        this.filterObj = reader.readObjectDetached();
        this.filterPlatform = this.filterObj == null ? (byte)0 : reader.readByte();
        this.pageSize = reader.readInt();
        int part0 = reader.readInt();
        this.part = part0 < 0 ? null : Integer.valueOf(part0);
        this.loc = reader.readBoolean();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteCache<Object, Object> cache = this.filterPlatform == 1 && !this.isKeepBinary() ? this.rawCache(ctx) : this.cache(ctx);
        ScanQuery qry = ((ScanQuery)((ScanQuery)new ScanQuery().setLocal(this.loc)).setPageSize(this.pageSize)).setPartition(this.part).setFilter(ClientCacheScanQueryRequest.createFilter(ctx.kernalContext(), this.filterObj, this.filterPlatform));
        if (this.part != null) {
            this.updateAffinityMetrics(ctx, this.part);
        }
        ctx.incrementCursors();
        try {
            QueryCursor<Cache.Entry> cur = cache.query(qry);
            ClientCacheEntryQueryCursor cliCur = new ClientCacheEntryQueryCursor(cur, this.pageSize, ctx);
            long cursorId = ctx.resources().put(cliCur);
            cliCur.id(cursorId);
            return new ClientCacheQueryResponse(this.requestId(), cliCur);
        }
        catch (Exception e) {
            ctx.decrementCursors();
            throw e;
        }
    }

    private static IgniteBiPredicate createFilter(GridKernalContext ctx, Object filterObj, byte filterPlatform) {
        if (filterObj == null) {
            return null;
        }
        switch (filterPlatform) {
            case 1: {
                return (IgniteBiPredicate)((BinaryObject)filterObj).deserialize();
            }
            case 2: {
                PlatformContext platformCtx = ctx.platform().context();
                String curPlatform = platformCtx.platform();
                if (!"dotnet".equals(curPlatform)) {
                    throw new IgniteException("ScanQuery filter platform is dotnet, current platform is " + curPlatform);
                }
                return platformCtx.createCacheEntryFilter(filterObj, 0L);
            }
        }
        throw new UnsupportedOperationException("Invalid client ScanQuery filter code: " + filterPlatform);
    }
}

