/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.binaryallocator.config;

import java.time.Duration;
import org.apache.iotdb.commons.conf.CommonDescriptor;

public class AllocatorConfig {
    public int minAllocateSize = CommonDescriptor.getInstance().getConfig().getMinAllocateSize();
    public int maxAllocateSize = CommonDescriptor.getInstance().getConfig().getMaxAllocateSize();
    public int arenaNum = CommonDescriptor.getInstance().getConfig().getArenaNum();
    public int log2ClassSizeGroup = CommonDescriptor.getInstance().getConfig().getLog2SizeClassGroup();
    public boolean enableBinaryAllocator = CommonDescriptor.getInstance().getConfig().isEnableBinaryAllocator();
    public Duration durationEvictorShutdownTimeout = Duration.ofMillis(1000L);
    public Duration durationBetweenEvictorRuns = Duration.ofMillis(1000L);
    public int arenaPredictionWeight = 35;
    public static final AllocatorConfig DEFAULT_CONFIG = new AllocatorConfig();

    public void setTimeBetweenEvictorRunsMillis(long time) {
        this.durationBetweenEvictorRuns = Duration.ofMillis(time);
    }
}

