/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFDirLangString;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Blank;
import org.apache.jena.graph.Node_Graph;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_Marker;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.Node_Variable;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.langtagx.LangTagX;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sys.JenaSystem;

public class NodeFactory {
    private NodeFactory() {
    }

    public static RDFDatatype getType(String s) {
        if (s == null) {
            return null;
        }
        return TypeMapper.getInstance().getSafeTypeByName(s);
    }

    public static Node createBlankNode() {
        return NodeFactory.createBlankNode(BlankNodeId.createFreshId());
    }

    public static Node createBlankNode(String string) {
        return new Node_Blank(string);
    }

    public static Node createURI(String uri) {
        Objects.requireNonNull(uri, "Argument to NodeFactory.createURI is null");
        return new Node_URI(uri);
    }

    public static Node createVariable(String name) {
        Objects.requireNonNull(name, "Argument to NodeFactory.createVariable is null");
        return new Node_Variable(name);
    }

    public static Node createExt(String name) {
        Objects.requireNonNull(name, "Argument to NodeFactory.createExt is null");
        return new Node_Marker(name);
    }

    @Deprecated
    public static Node createLiteral(LiteralLabel lit) {
        Objects.requireNonNull(lit, "Argument to NodeFactory.createLiteral is null");
        return new Node_Literal(lit);
    }

    @Deprecated(forRemoval=true)
    public static Node createLiteral(String string) {
        return NodeFactory.createLiteralString(string);
    }

    public static Node createLiteralString(String string) {
        Objects.requireNonNull(string, "Argument to NodeFactory.createLiteralString is null");
        return new Node_Literal(string);
    }

    @Deprecated(forRemoval=true)
    public static Node createLiteral(String string, String lang) {
        return NodeFactory.createLiteralLang(string, lang);
    }

    public static Node createLiteralLang(String string, String lang) {
        Objects.requireNonNull(string, "null lexical form for literal");
        if (Lib.isEmpty((CharSequence)lang)) {
            return new Node_Literal(string);
        }
        int idx = lang.indexOf("--");
        if (idx >= 0) {
            String textDir = lang.substring(idx + 2);
            if (textDir.isEmpty()) {
                throw new JenaException("Empty base direction after '--'");
            }
            lang = lang.substring(0, idx);
            return NodeFactory.createLiteralDirLang(string, lang, textDir);
        }
        String langFmt = LangTagX.formatLanguageTag(lang);
        return new Node_Literal(string, langFmt);
    }

    public static Node createLiteralDirLang(String string, String lang, String textDir) {
        TextDirection textDirEnum = NodeFactory.initialTextDirection(textDir);
        return NodeFactory.createLiteralDirLang(string, lang, textDirEnum);
    }

    private static boolean noTextDir(TextDirection textDir) {
        return textDir == Node.noTextDirection;
    }

    public static Node createLiteralDirLang(String string, String lang, TextDirection textDir) {
        Objects.requireNonNull(string, "null lexical form for literal");
        if (Lib.isEmpty((CharSequence)lang)) {
            if (textDir != null) {
                throw new JenaException("The language must be given for a language direction literal");
            }
            return new Node_Literal(string);
        }
        if (NodeFactory.noTextDir(textDir)) {
            return new Node_Literal(string, lang);
        }
        String langFmt = LangTagX.formatLanguageTag(lang);
        return new Node_Literal(string, langFmt, textDir);
    }

    public static Node createLiteral(String lex, String lang, RDFDatatype dtype) {
        return NodeFactory.createLiteralInternal(lex, lang, Node.noTextDirection, dtype);
    }

    public static Node createLiteral(String lex, String lang, String textDir, RDFDatatype dtype) {
        TextDirection textDirEnum = NodeFactory.initialTextDirection(textDir);
        return NodeFactory.createLiteralInternal(lex, lang, textDirEnum, dtype);
    }

    public static Node createLiteral(String lex, String lang, TextDirection textDir, RDFDatatype dtype) {
        return NodeFactory.createLiteralInternal(lex, lang, textDir, dtype);
    }

    private static Node createLiteralInternal(String lex, String lang, TextDirection textDir, RDFDatatype dtype) {
        boolean hasTextDirLang;
        Objects.requireNonNull(lex, "null lexical form for literal");
        boolean hasLang = !Lib.isEmpty((CharSequence)lang);
        boolean bl = hasTextDirLang = !NodeFactory.noTextDir(textDir);
        if (hasTextDirLang && !hasLang) {
            throw new JenaException("The language must be given for a language direction literal");
        }
        if (hasLang) {
            if (!hasTextDirLang) {
                if (dtype != null && !dtype.equals(RDFLangString.rdfLangString)) {
                    throw new JenaException("Datatype is not rdf:langString but a language was given");
                }
                return NodeFactory.createLiteralLang(lex, lang);
            }
            if (dtype != null && !dtype.equals(RDFDirLangString.rdfDirLangString)) {
                throw new JenaException("Datatype is not rdf:dirLangString but a language and initial text direction was given");
            }
            return NodeFactory.createLiteralDirLang(lex, lang, textDir);
        }
        if (dtype == null) {
            return NodeFactory.createLiteralString(lex);
        }
        Node n = NodeFactory.createLiteralDT(lex, dtype);
        return n;
    }

    private static TextDirection initialTextDirection(String input) {
        if (Lib.isEmpty((CharSequence)input)) {
            return Node.noTextDirection;
        }
        TextDirection textDir = TextDirection.create(input);
        return textDir;
    }

    @Deprecated
    public static Node createLiteral(String lex, RDFDatatype dtype) {
        return NodeFactory.createLiteralDT(lex, dtype);
    }

    public static Node createLiteralDT(String lex, RDFDatatype dtype) {
        Objects.requireNonNull(lex, "null lexical form for literal");
        if (dtype == null) {
            dtype = XSDDatatype.XSDstring;
        }
        return new Node_Literal(lex, dtype);
    }

    public static Node createLiteralByValue(Object value) {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return new Node_Literal(LiteralLabelFactory.createByValue(value));
    }

    public static Node createLiteralByValue(Object value, RDFDatatype dtype) {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return new Node_Literal(LiteralLabelFactory.createByValue(value, dtype));
    }

    public static Node createTripleTerm(Node s, Node p, Node o) {
        return new Node_Triple(s, p, o);
    }

    public static Node createTripleTerm(Triple triple) {
        return new Node_Triple(triple);
    }

    @Deprecated
    public static Node createTripleNode(Node s, Node p, Node o) {
        return NodeFactory.createTripleTerm(s, p, o);
    }

    @Deprecated
    public static Node createTripleNode(Triple triple) {
        return NodeFactory.createTripleTerm(triple);
    }

    public static Node createGraphNode(Graph graph) {
        return new Node_Graph(graph);
    }

    static {
        JenaSystem.init();
    }
}

