/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAntiJoin;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementDataset;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementSemiJoin;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnfold;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;

public class ElementTransformCopyBase
implements ElementTransform {
    protected boolean alwaysCopy = false;

    public ElementTransformCopyBase() {
        this(false);
    }

    public ElementTransformCopyBase(boolean alwaysCopy) {
        this.alwaysCopy = alwaysCopy;
    }

    @Override
    public Element transform(ElementTriplesBlock el) {
        if (this.alwaysCopy) {
            BasicPattern before = el.getPattern();
            BasicPattern copy = new BasicPattern();
            before.getList().forEach(copy::add);
            el = new ElementTriplesBlock(copy);
        }
        return el;
    }

    @Override
    public Element transform(ElementPathBlock el) {
        if (this.alwaysCopy) {
            PathBlock before = el.getPattern();
            PathBlock copy = new PathBlock();
            before.getList().forEach(copy::add);
            el = new ElementPathBlock(copy);
        }
        return el;
    }

    @Override
    public Triple transform(Triple triple) {
        return triple;
    }

    @Override
    public Quad transform(Quad quad) {
        return quad;
    }

    @Override
    public Element transform(ElementFilter el, Expr expr2) {
        if (!this.alwaysCopy && el.getExpr() == expr2) {
            return el;
        }
        return new ElementFilter(expr2);
    }

    @Override
    public Element transform(ElementAssign el, Var v, Expr expr2) {
        if (!this.alwaysCopy && el.getVar() == v && el.getExpr() == expr2) {
            return el;
        }
        return new ElementAssign(v, expr2);
    }

    @Override
    public Element transform(ElementBind el, Var v, Expr expr2) {
        if (!this.alwaysCopy && el.getVar() == v && el.getExpr() == expr2) {
            return el;
        }
        return new ElementBind(v, expr2);
    }

    @Override
    public Element transform(ElementUnfold el, Expr expr, Var v1, Var v2) {
        if (!this.alwaysCopy && el.getVar1() == v1 && el.getVar2() == v2 && el.getExpr() == expr) {
            return el;
        }
        return new ElementUnfold(expr, v1, v2);
    }

    @Override
    public Element transform(ElementData el) {
        if (this.alwaysCopy) {
            ElementData copy = new ElementData();
            el.getVars().forEach(copy::add);
            el.getTable().rows().forEachRemaining(copy::add);
            el = copy;
        }
        return el;
    }

    @Override
    public Element transform(ElementUnion el, List<Element> elts) {
        if (!this.alwaysCopy && el.getElements() == elts) {
            return el;
        }
        ElementUnion el2 = new ElementUnion();
        el2.getElements().addAll(elts);
        return el2;
    }

    @Override
    public Element transform(ElementOptional el, Element elt1) {
        if (!this.alwaysCopy && el.getOptionalElement() == elt1) {
            return el;
        }
        return new ElementOptional(elt1);
    }

    @Override
    public Element transform(ElementLateral el, Element elt1) {
        if (!this.alwaysCopy && el.getLateralElement() == elt1) {
            return el;
        }
        return new ElementLateral(elt1);
    }

    @Override
    public Element transform(ElementSemiJoin el, Element elt1) {
        if (!this.alwaysCopy && el.getSubElement() == elt1) {
            return el;
        }
        return new ElementSemiJoin(elt1);
    }

    @Override
    public Element transform(ElementAntiJoin el, Element elt1) {
        if (!this.alwaysCopy && el.getSubElement() == elt1) {
            return el;
        }
        return new ElementAntiJoin(elt1);
    }

    @Override
    public Element transform(ElementGroup el, List<Element> elts) {
        if (!this.alwaysCopy && el.getElements() == elts) {
            return el;
        }
        ElementGroup el2 = new ElementGroup();
        el2.getElements().addAll(elts);
        return el2;
    }

    @Override
    public Element transform(ElementDataset el, Element elt1) {
        if (!this.alwaysCopy && el.getElement() == elt1) {
            return el;
        }
        return new ElementDataset(el.getDataset(), elt1);
    }

    @Override
    public Element transform(ElementNamedGraph el, Node gn, Element elt1) {
        if (!this.alwaysCopy && el.getGraphNameNode() == gn && el.getElement() == elt1) {
            return el;
        }
        return new ElementNamedGraph(gn, elt1);
    }

    @Override
    public Element transform(ElementExists el, Element elt1) {
        if (!this.alwaysCopy && el.getElement() == elt1) {
            return el;
        }
        return new ElementExists(elt1);
    }

    @Override
    public Element transform(ElementNotExists el, Element elt1) {
        if (!this.alwaysCopy && el.getElement() == elt1) {
            return el;
        }
        return new ElementNotExists(elt1);
    }

    @Override
    public Element transform(ElementMinus el, Element elt1) {
        if (!this.alwaysCopy && el.getMinusElement() == elt1) {
            return el;
        }
        return new ElementMinus(elt1);
    }

    @Override
    public Element transform(ElementService el, Node service, Element elt1) {
        if (!this.alwaysCopy && el.getServiceNode() == service && el.getElement() == elt1) {
            return el;
        }
        return new ElementService(service, elt1, el.getSilent());
    }

    @Override
    public Element transform(ElementSubQuery el, Query query2) {
        if (!this.alwaysCopy && el.getQuery() == query2) {
            return el;
        }
        return new ElementSubQuery(query2);
    }
}

