/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connection.utils;

import javax.resource.spi.ConnectionRequestInfo;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnection;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnectionFactory;

public abstract class AbstractConnectionHandle<MCF extends AbstractManagedConnectionFactory<MCF, MC, C, CI>, MC extends AbstractManagedConnection<MCF, MC, C, CI>, C, CI extends AbstractConnectionHandle<MCF, MC, C, CI>> {
    protected final MCF mcf;
    protected final ConnectionRequestInfo cri;
    protected final MC mc;
    protected volatile boolean closed = false;

    protected AbstractConnectionHandle(MCF mcf, ConnectionRequestInfo cri, MC mc) {
        this.mcf = mcf;
        this.cri = cri;
        this.mc = mc;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed) {
            AbstractConnectionHandle abstractConnectionHandle = this;
            synchronized (abstractConnectionHandle) {
                if (!this.closed) {
                    this.closed = true;
                    this.doClose();
                }
            }
        }
    }

    protected void doClose() {
        ((AbstractManagedConnection)this.mc).connectionClosed((AbstractConnectionHandle)this);
    }

    public void connectionError(Exception e) {
        ((AbstractManagedConnection)this.mc).connectionError(e);
    }

    protected abstract <E extends Exception> E wrapException(String var1, Exception var2);

    public <E extends Exception> MC getManagedConnection() throws E {
        if (this.isClosed()) {
            throw this.wrapException("Connection has been closed", null);
        }
        return this.mc;
    }

    protected <E extends Exception> void execute(Runnable<C> cb) throws E {
        try {
            cb.run(((AbstractManagedConnection)this.getManagedConnection()).getPhysicalConnection());
        }
        catch (Exception e) {
            this.connectionError(e);
            throw this.wrapException(null, e);
        }
    }

    protected <E extends Exception, R> R call(Callable<C, R> cb) throws E {
        try {
            return cb.call(((AbstractManagedConnection)this.getManagedConnection()).getPhysicalConnection());
        }
        catch (Exception e) {
            this.connectionError(e);
            throw this.wrapException(null, e);
        }
    }

    protected static interface Callable<T, R> {
        public R call(T var1) throws Exception;
    }

    protected static interface Runnable<T> {
        public void run(T var1) throws Exception;
    }
}

