/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.internal;

import java.io.Closeable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    Closeable dumpHandler;

    public void start(BundleContext context) throws Exception {
        if (!this.isWindows()) {
            ClassLoader cl = this.getClass().getClassLoader();
            try {
                Class<?> dumpHandlerClazz = cl.loadClass("org.apache.karaf.diagnostic.core.internal.DumpHandler");
                this.dumpHandler = (Closeable)dumpHandlerClazz.getConstructor(BundleContext.class).newInstance(context);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.dumpHandler != null && !this.isWindows()) {
            this.dumpHandler.close();
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "Unknown").startsWith("Win");
    }
}

