/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client;

import java.util.HashMap;
import org.apache.kyuubi.client.IRestClient;
import org.apache.kyuubi.client.KyuubiRestClient;
import org.apache.kyuubi.client.api.v1.dto.KyuubiOperationEvent;
import org.apache.kyuubi.client.api.v1.dto.OpActionRequest;
import org.apache.kyuubi.client.api.v1.dto.OperationLog;
import org.apache.kyuubi.client.api.v1.dto.ResultRowSet;
import org.apache.kyuubi.client.api.v1.dto.ResultSetMetaData;
import org.apache.kyuubi.client.util.JsonUtils;

public class OperationRestApi {
    private KyuubiRestClient client;
    private static final String API_BASE_PATH = "operations";

    private OperationRestApi() {
    }

    public OperationRestApi(KyuubiRestClient client) {
        this.client = client;
    }

    public KyuubiOperationEvent getOperationEvent(String operationHandleStr) {
        String path = String.format("%s/%s/event", API_BASE_PATH, operationHandleStr);
        return this.getClient().get(path, new HashMap<String, Object>(), KyuubiOperationEvent.class, this.client.getAuthHeader());
    }

    public String applyOperationAction(OpActionRequest request, String operationHandleStr) {
        String path = String.format("%s/%s", API_BASE_PATH, operationHandleStr);
        return this.getClient().put(path, JsonUtils.toJson(request), this.client.getAuthHeader());
    }

    public ResultSetMetaData getResultSetMetadata(String operationHandleStr) {
        String path = String.format("%s/%s/resultsetmetadata", API_BASE_PATH, operationHandleStr);
        return this.getClient().get(path, new HashMap<String, Object>(), ResultSetMetaData.class, this.client.getAuthHeader());
    }

    public OperationLog getOperationLog(String operationHandleStr, int maxRows) {
        String path = String.format("%s/%s/log", API_BASE_PATH, operationHandleStr);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("maxrows", maxRows);
        return this.getClient().get(path, params, OperationLog.class, this.client.getAuthHeader());
    }

    public ResultRowSet getNextRowSet(String operationHandleStr) {
        return this.getNextRowSet(operationHandleStr, null, null);
    }

    public ResultRowSet getNextRowSet(String operationHandleStr, String fetchOrientation, Integer maxRows) {
        String path = String.format("%s/%s/rowset", API_BASE_PATH, operationHandleStr);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fetchOrientation != null) {
            params.put("fetchorientation", fetchOrientation);
        }
        if (maxRows != null) {
            params.put("maxrows", maxRows);
        }
        return this.getClient().get(path, params, ResultRowSet.class, this.client.getAuthHeader());
    }

    private IRestClient getClient() {
        return this.client.getHttpClient();
    }
}

