/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.hive.metastore.utils;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.kyuubi.shaded.hive.metastore.api.MetaException;
import org.apache.kyuubi.shaded.hive.metastore.security.HadoopThriftAuthBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreUtils.class);
    public static final String USER_NAME_HTTP_HEADER = "x-actor-username";

    public static void throwMetaException(Exception e) throws MetaException {
        throw new MetaException("Got exception: " + e.getClass().getName() + " " + e.getMessage());
    }

    public static Map<String, String> getMetaStoreSaslProperties(Configuration conf, boolean useSSL) {
        String hadoopRpcProtectionVal = conf.get("hadoop.rpc.protection");
        String hadoopRpcProtectionAuth = SaslRpcServer.QualityOfProtection.AUTHENTICATION.toString();
        if (useSSL && hadoopRpcProtectionVal != null && !hadoopRpcProtectionVal.equals(hadoopRpcProtectionAuth)) {
            LOG.warn("Overriding value of hadoop.rpc.protection setting it from " + hadoopRpcProtectionVal + " to " + hadoopRpcProtectionAuth + " because SSL is enabled");
            conf.set("hadoop.rpc.protection", hadoopRpcProtectionAuth);
        }
        return HadoopThriftAuthBridge.getBridge().getHadoopSaslProperties(conf);
    }

    public static String getHttpPath(String httpPath) {
        if (httpPath == null || httpPath.equals("")) {
            httpPath = "/*";
        } else {
            if (!httpPath.startsWith("/")) {
                httpPath = "/" + httpPath;
            }
            if (httpPath.endsWith("/")) {
                httpPath = httpPath + "*";
            }
            if (!httpPath.endsWith("/*")) {
                httpPath = httpPath + "/*";
            }
        }
        return httpPath;
    }
}

