/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.api.lock;

import io.etcd.jetcd.api.lock.LockGrpc;
import io.etcd.jetcd.api.lock.LockRequest;
import io.etcd.jetcd.api.lock.LockResponse;
import io.etcd.jetcd.api.lock.UnlockRequest;
import io.etcd.jetcd.api.lock.UnlockResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.grpc.stub.ClientCalls;

public final class VertxLockGrpc {
    private static final int METHODID_LOCK = 0;
    private static final int METHODID_UNLOCK = 1;

    private VertxLockGrpc() {
    }

    public static LockVertxStub newVertxStub(Channel channel) {
        return new LockVertxStub(channel);
    }

    public static final class LockVertxStub
    extends AbstractStub<LockVertxStub> {
        private final ContextInternal ctx;
        private LockGrpc.LockStub delegateStub;

        private LockVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = LockGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private LockVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = LockGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        protected LockVertxStub build(Channel channel, CallOptions callOptions) {
            return new LockVertxStub(channel, callOptions);
        }

        public Future<LockResponse> lock(LockRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::lock);
        }

        public Future<UnlockResponse> unlock(UnlockRequest request) {
            return ClientCalls.oneToOne((ContextInternal)this.ctx, (Object)request, this.delegateStub::unlock);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final LockVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(LockVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((LockRequest)request), responseObserver, (String)this.compression, this.serviceImpl::lock);
                    break;
                }
                case 1: {
                    io.vertx.grpc.stub.ServerCalls.oneToOne((Object)((UnlockRequest)request), responseObserver, (String)this.compression, this.serviceImpl::unlock);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class LockVertxImplBase
    implements BindableService {
        private String compression;

        public LockVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<LockResponse> lock(LockRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<UnlockResponse> unlock(UnlockRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)LockGrpc.getServiceDescriptor()).addMethod(LockGrpc.getLockMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(LockGrpc.getUnlockMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).build();
        }
    }
}

