/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jline;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.Prompter;
import org.apache.maven.api.services.PrompterException;
import org.apache.maven.jline.MessageUtils;

@Named
@Singleton
@Experimental
public class DefaultPrompter
implements Prompter {
    public String prompt(String message, List<String> possibleValues, String defaultReply) throws PrompterException {
        return this.doPrompt(message, possibleValues, defaultReply, false);
    }

    public String promptForPassword(String message) throws PrompterException {
        return this.doPrompt(message, null, null, true);
    }

    public void showMessage(String message) throws PrompterException {
        this.doDisplay(message);
    }

    private String doPrompt(String message, boolean password) {
        try {
            if (message != null) {
                if (!((String)message).endsWith("\n")) {
                    if (((String)message).endsWith(":")) {
                        message = (String)message + " ";
                    } else if (!((String)message).endsWith(": ")) {
                        message = (String)message + ": ";
                    }
                }
                int lastNl = ((String)message).lastIndexOf(10);
                String begin = ((String)message).substring(0, lastNl + 1);
                message = ((String)message).substring(lastNl + 1);
                MessageUtils.terminal.writer().print(begin);
                MessageUtils.terminal.flush();
            }
            return MessageUtils.reader.readLine((String)message, password ? Character.valueOf('*') : null);
        }
        catch (Exception e) {
            throw new PrompterException("Unable to prompt user", e);
        }
    }

    private void doDisplay(String message) {
        try {
            MessageUtils.terminal.writer().print(message);
            MessageUtils.terminal.flush();
        }
        catch (Exception e) {
            throw new PrompterException("Unable to display message", e);
        }
    }

    private String doPrompt(String message, List<?> possibleValues, String defaultReply, boolean password) {
        String line;
        String formattedMessage = this.formatMessage(message, possibleValues, defaultReply);
        do {
            if ((line = this.doPrompt(formattedMessage, password)) == null && defaultReply == null) {
                throw new PrompterException("EOF");
            }
            if (line == null || line.isEmpty()) {
                line = defaultReply;
            }
            if (line == null || possibleValues == null || possibleValues.contains(line)) continue;
            this.doDisplay("Invalid selection.\n");
        } while (line == null || possibleValues != null && !possibleValues.contains(line));
        return line;
    }

    private String formatMessage(String message, List<?> possibleValues, String defaultReply) {
        if (message == null) {
            return null;
        }
        StringBuilder formatted = new StringBuilder(message.length() * 2);
        formatted.append(message);
        if (possibleValues != null && !possibleValues.isEmpty()) {
            formatted.append(" (");
            Iterator<?> it = possibleValues.iterator();
            while (it.hasNext()) {
                String possibleValue = String.valueOf(it.next());
                formatted.append(possibleValue);
                if (!it.hasNext()) continue;
                formatted.append('/');
            }
            formatted.append(')');
        }
        if (defaultReply != null) {
            formatted.append(' ').append(defaultReply).append(": ");
        }
        return formatted.toString();
    }
}

