/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.lifecycle;

import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.webapp.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretPhaseListener
implements PhaseListener {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void afterPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(facesContext);
        if (!facesContext.getResponseComplete() && facesContext.isPostback() && tobagoConfig.isCheckSessionSecret() && !this.check(facesContext)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Secret is invalid!");
            }
            facesContext.renderResponse();
        }
    }

    private boolean check(FacesContext facesContext) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String secretFromRequest = (String)requestParameterMap.get(Secret.KEY);
        Secret secret = Secret.getInstance(facesContext);
        return secret.check(secretFromRequest);
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

