/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class Group {
    private final String identifier;
    private final String name;
    private final Set<String> users;

    private Group(Builder builder) {
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.users = Collections.unmodifiableSet(new HashSet<String>(builder.users));
        if (this.identifier == null || this.identifier.isBlank()) {
            throw new IllegalArgumentException("Identifier can not be null or empty");
        }
        if (this.name == null || this.name.isBlank()) {
            throw new IllegalArgumentException("Name can not be null or empty");
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    public int hashCode() {
        return Objects.hashCode(this.identifier);
    }

    public String toString() {
        return String.format("identifier[%s], name[%s], users[%s]", this.getIdentifier(), this.getName(), String.join((CharSequence)", ", this.users));
    }

    public static class Builder {
        private String identifier;
        private String name;
        private Set<String> users = new HashSet<String>();
        private final boolean fromGroup;

        public Builder() {
            this.fromGroup = false;
        }

        public Builder(Group other) {
            if (other == null) {
                throw new IllegalArgumentException("Provided group can not be null");
            }
            this.identifier = other.getIdentifier();
            this.name = other.getName();
            this.users.clear();
            this.users.addAll(other.getUsers());
            this.fromGroup = true;
        }

        public Builder identifier(String identifier) {
            if (this.fromGroup) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing group");
            }
            this.identifier = identifier;
            return this;
        }

        public Builder identifierGenerateRandom() {
            if (this.fromGroup) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing group");
            }
            this.identifier = UUID.randomUUID().toString();
            return this;
        }

        public Builder identifierGenerateFromSeed(String seed) {
            if (this.fromGroup) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing group");
            }
            if (seed == null) {
                throw new IllegalArgumentException("Cannot seed the group identifier with a null value.");
            }
            this.identifier = UUID.nameUUIDFromBytes(seed.getBytes(StandardCharsets.UTF_8)).toString();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addUsers(Set<String> users) {
            if (users != null) {
                this.users.addAll(users);
            }
            return this;
        }

        public Builder addUser(String user) {
            if (user != null) {
                this.users.add(user);
            }
            return this;
        }

        public Builder removeUser(String user) {
            if (user != null) {
                this.users.remove(user);
            }
            return this;
        }

        public Builder removeUsers(Set<String> users) {
            if (users != null) {
                this.users.removeAll(users);
            }
            return this;
        }

        public Builder clearUsers() {
            this.users.clear();
            return this;
        }

        public Group build() {
            return new Group(this);
        }
    }
}

