/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.protocol.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.nifi.remote.AbstractTransaction;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.SiteToSiteEventReporter;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.protocol.RequestType;
import org.apache.nifi.remote.protocol.Response;
import org.apache.nifi.remote.protocol.ResponseCode;

public class SocketClientTransaction
extends AbstractTransaction {
    private final DataInputStream dis;
    private final DataOutputStream dos;

    SocketClientTransaction(int protocolVersion, String destinationId, Peer peer, FlowFileCodec codec, TransferDirection direction, boolean useCompression, int penaltyMillis, SiteToSiteEventReporter eventReporter) throws IOException {
        super(peer, direction, useCompression, codec, eventReporter, protocolVersion, penaltyMillis, destinationId);
        this.dis = new DataInputStream(peer.getCommunicationsSession().getInput().getInputStream());
        this.dos = new DataOutputStream(peer.getCommunicationsSession().getOutput().getOutputStream());
        this.initialize();
    }

    private void initialize() throws IOException {
        try {
            if (this.direction == TransferDirection.RECEIVE) {
                RequestType.RECEIVE_FLOWFILES.writeRequestType(this.dos);
                this.dos.flush();
                Response dataAvailableCode = Response.read(this.dis);
                switch (dataAvailableCode.getCode()) {
                    case MORE_DATA: {
                        this.logger.debug("{} {} Indicates that data is available", (Object)this, (Object)this.peer);
                        this.dataAvailable = true;
                        break;
                    }
                    case NO_MORE_DATA: {
                        this.logger.debug("{} No data available from {}", (Object)this, (Object)this.peer);
                        this.dataAvailable = false;
                        return;
                    }
                    default: {
                        throw new ProtocolException("Got unexpected response when asking for data: " + String.valueOf(dataAvailableCode));
                    }
                }
            } else {
                RequestType.SEND_FLOWFILES.writeRequestType(this.dos);
                this.dos.flush();
            }
        }
        catch (Exception e) {
            this.error();
            throw e;
        }
    }

    @Override
    protected Response readTransactionResponse() throws IOException {
        return Response.read(this.dis);
    }

    @Override
    protected void writeTransactionResponse(ResponseCode response, String explanation, boolean flush) throws IOException {
        if (explanation == null) {
            response.writeResponse(this.dos, flush);
        } else {
            response.writeResponse(this.dos, explanation, flush);
        }
    }
}

