/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.Cons;
import opennlp.tools.parser.Parse;

public abstract class AbstractContextGenerator {
    protected static final String EOS = "eos";
    protected boolean zeroBackOff;
    protected Set<String> punctSet;
    protected boolean useLabel;

    protected String punct(Parse punct, int i) {
        return i + "=" + punct.getCoveredText();
    }

    protected String punctbo(Parse punct, int i) {
        return i + "=" + punct.getType();
    }

    protected String cons(Parse p, int i) {
        StringBuilder feat = new StringBuilder(20);
        feat.append(i).append("=");
        if (p != null) {
            if (this.useLabel && i < 0) {
                feat.append(p.getLabel()).append("|");
            }
            feat.append(p.getType()).append("|").append(p.getHead().getCoveredText());
        } else {
            feat.append(EOS);
        }
        return feat.toString();
    }

    protected String consbo(Parse p, int i) {
        StringBuilder feat = new StringBuilder(20);
        feat.append(i).append("*=");
        if (p != null) {
            if (this.useLabel && i < 0) {
                feat.append(p.getLabel()).append("|");
            }
            feat.append(p.getType());
        } else {
            feat.append(EOS);
        }
        return feat.toString();
    }

    protected String production(Parse p, boolean includePunctuation) {
        StringBuilder production = new StringBuilder(20);
        production.append(p.getType()).append("->");
        Parse[] children = AbstractBottomUpParser.collapsePunctuation(p.getChildren(), this.punctSet);
        for (int ci = 0; ci < children.length; ++ci) {
            production.append(children[ci].getType());
            if (ci + 1 == children.length) continue;
            production.append(",");
            Collection nextPunct = children[ci].getNextPunctuationSet();
            if (!includePunctuation || nextPunct == null) continue;
            for (Parse punct : nextPunct) {
                production.append(punct.getType()).append(",");
            }
        }
        return production.toString();
    }

    protected void cons2(List<String> features, Cons c0, Cons c1, Collection<Parse> punct1s, boolean bigram) {
        if (punct1s != null) {
            for (Parse p : punct1s) {
                String punctbo = this.punctbo(p, c1.index <= 0 ? c1.index - 1 : c1.index);
                features.add(punctbo);
                if (c0.index == 0) {
                    if (c0.unigram) {
                        features.add(c0.cons + "," + punctbo);
                    }
                    features.add(c0.consbo + "," + punctbo);
                }
                if (c1.index == 0) {
                    if (c1.unigram) {
                        features.add(punctbo + "," + c1.cons);
                    }
                    features.add(punctbo + "," + c1.consbo);
                }
                if (bigram) {
                    features.add(c0.cons + "," + punctbo + "," + c1.cons);
                }
                if (c1.unigram) {
                    features.add(c0.consbo + "," + punctbo + "," + c1.cons);
                }
                if (c0.unigram) {
                    features.add(c0.cons + "," + punctbo + "," + c1.consbo);
                }
                features.add(c0.consbo + "," + punctbo + "," + c1.consbo);
            }
        } else {
            if (bigram) {
                features.add(c0.cons + "," + c1.cons);
            }
            if (c1.unigram) {
                features.add(c0.consbo + "," + c1.cons);
            }
            if (c0.unigram) {
                features.add(c0.cons + "," + c1.consbo);
            }
            features.add(c0.consbo + "," + c1.consbo);
        }
    }

    protected void cons3(List<String> features, Cons c0, Cons c1, Cons c2, Collection<Parse> punct1s, Collection<Parse> punct2s, boolean trigram, boolean bigram1, boolean bigram2) {
        String punctbo;
        if (punct1s != null && c0.index == -2) {
            for (Parse p : punct1s) {
                punctbo = this.punctbo(p, c1.index <= 0 ? c1.index - 1 : c1.index);
                features.add(punctbo);
            }
        }
        if (punct2s != null) {
            if (c2.index == 2) {
                for (Parse p : punct2s) {
                    punctbo = this.punctbo(p, c2.index);
                    features.add(punctbo);
                }
            }
            if (punct1s != null) {
                for (Parse punct2 : punct2s) {
                    punctbo2 = this.punctbo(punct2, c2.index <= 0 ? c2.index - 1 : c2.index);
                    for (Parse punct1 : punct1s) {
                        String punctbo1 = this.punctbo(punct1, c1.index <= 0 ? c1.index - 1 : c1.index);
                        if (trigram) {
                            features.add(c0.cons + "," + punctbo1 + "," + c1.cons + "," + punctbo2 + "," + c2.cons);
                        }
                        if (bigram2) {
                            features.add(c0.consbo + "," + punctbo1 + "," + c1.cons + "," + punctbo2 + "," + c2.cons);
                        }
                        if (c0.unigram && c2.unigram) {
                            features.add(c0.cons + "," + punctbo1 + "," + c1.consbo + "," + punctbo2 + "," + c2.cons);
                        }
                        if (bigram1) {
                            features.add(c0.cons + "," + punctbo1 + "," + c1.cons + "," + punctbo2 + "," + c2.consbo);
                        }
                        if (c2.unigram) {
                            features.add(c0.consbo + "," + punctbo1 + "," + c1.consbo + "," + punctbo2 + "," + c2.cons);
                        }
                        if (c1.unigram) {
                            features.add(c0.consbo + "," + punctbo1 + "," + c1.cons + "," + punctbo2 + "," + c2.consbo);
                        }
                        if (c0.unigram) {
                            features.add(c0.cons + "," + punctbo1 + "," + c1.consbo + "," + punctbo2 + "," + c2.consbo);
                        }
                        features.add(c0.consbo + "," + punctbo1 + "," + c1.consbo + "," + punctbo2 + "," + c2.consbo);
                        if (!this.zeroBackOff) continue;
                        if (bigram1) {
                            features.add(c0.cons + "," + punctbo1 + "," + c1.cons + "," + punctbo2);
                        }
                        if (c1.unigram) {
                            features.add(c0.consbo + "," + punctbo1 + "," + c1.cons + "," + punctbo2);
                        }
                        if (c0.unigram) {
                            features.add(c0.cons + "," + punctbo1 + "," + c1.consbo + "," + punctbo2);
                        }
                        features.add(c0.consbo + "," + punctbo1 + "," + c1.consbo + "," + punctbo2);
                    }
                }
            } else {
                for (Parse punct2 : punct2s) {
                    punctbo2 = this.punctbo(punct2, c2.index <= 0 ? c2.index - 1 : c2.index);
                    if (trigram) {
                        features.add(c0.cons + "," + c1.cons + "," + punctbo2 + "," + c2.cons);
                    }
                    if (bigram2) {
                        features.add(c0.consbo + "," + c1.cons + "," + punctbo2 + "," + c2.cons);
                    }
                    if (c0.unigram && c2.unigram) {
                        features.add(c0.cons + "," + c1.consbo + "," + punctbo2 + "," + c2.cons);
                    }
                    if (bigram1) {
                        features.add(c0.cons + "," + c1.cons + "," + punctbo2 + "," + c2.consbo);
                    }
                    if (c2.unigram) {
                        features.add(c0.consbo + "," + c1.consbo + "," + punctbo2 + "," + c2.cons);
                    }
                    if (c1.unigram) {
                        features.add(c0.consbo + "," + c1.cons + "," + punctbo2 + "," + c2.consbo);
                    }
                    if (c0.unigram) {
                        features.add(c0.cons + "," + c1.consbo + "," + punctbo2 + "," + c2.consbo);
                    }
                    features.add(c0.consbo + "," + c1.consbo + "," + punctbo2 + "," + c2.consbo);
                    if (!this.zeroBackOff) continue;
                    if (bigram1) {
                        features.add(c0.cons + "," + c1.cons + "," + punctbo2);
                    }
                    if (c1.unigram) {
                        features.add(c0.consbo + "," + c1.cons + "," + punctbo2);
                    }
                    if (c0.unigram) {
                        features.add(c0.cons + "," + c1.consbo + "," + punctbo2);
                    }
                    features.add(c0.consbo + "," + c1.consbo + "," + punctbo2);
                }
            }
        } else if (punct1s != null) {
            for (Parse punct1 : punct1s) {
                String punctbo1 = this.punctbo(punct1, c1.index <= 0 ? c1.index - 1 : c1.index);
                if (trigram) {
                    features.add(c0.cons + "," + punctbo1 + "," + c1.cons + "," + c2.cons);
                }
                if (bigram2) {
                    features.add(c0.consbo + "," + punctbo1 + "," + c1.cons + "," + c2.cons);
                }
                if (c0.unigram && c2.unigram) {
                    features.add(c0.cons + "," + punctbo1 + "," + c1.consbo + "," + c2.cons);
                }
                if (bigram1) {
                    features.add(c0.cons + "," + punctbo1 + "," + c1.cons + "," + c2.consbo);
                }
                if (c2.unigram) {
                    features.add(c0.consbo + "," + punctbo1 + "," + c1.consbo + "," + c2.cons);
                }
                if (c1.unigram) {
                    features.add(c0.consbo + "," + punctbo1 + "," + c1.cons + "," + c2.consbo);
                }
                if (c0.unigram) {
                    features.add(c0.cons + "," + punctbo1 + "," + c1.consbo + "," + c2.consbo);
                }
                features.add(c0.consbo + "," + punctbo1 + "," + c1.consbo + "," + c2.consbo);
            }
        } else {
            if (trigram) {
                features.add(c0.cons + "," + c1.cons + "," + c2.cons);
            }
            if (bigram2) {
                features.add(c0.consbo + "," + c1.cons + "," + c2.cons);
            }
            if (c0.unigram && c2.unigram) {
                features.add(c0.cons + "," + c1.consbo + "," + c2.cons);
            }
            if (bigram1) {
                features.add(c0.cons + "," + c1.cons + "," + c2.consbo);
            }
            if (c2.unigram) {
                features.add(c0.consbo + "," + c1.consbo + "," + c2.cons);
            }
            if (c1.unigram) {
                features.add(c0.consbo + "," + c1.cons + "," + c2.consbo);
            }
            if (c0.unigram) {
                features.add(c0.cons + "," + c1.consbo + "," + c2.consbo);
            }
            features.add(c0.consbo + "," + c1.consbo + "," + c2.consbo);
        }
    }

    protected void surround(Parse node, int i, String type, Collection<Parse> punctuation, List<String> features) {
        StringBuilder feat = new StringBuilder(20);
        feat.append("s").append(i).append("=");
        if (punctuation != null) {
            for (Parse punct : punctuation) {
                if (node != null) {
                    feat.append(node.getHead().getCoveredText()).append("|").append(type).append("|").append(node.getType()).append("|").append(punct.getType());
                } else {
                    feat.append(type).append("|").append(EOS).append("|").append(punct.getType());
                }
                features.add(feat.toString());
                feat.setLength(0);
                feat.append("s").append(i).append("*=");
                if (node != null) {
                    feat.append(type).append("|").append(node.getType()).append("|").append(punct.getType());
                } else {
                    feat.append(type).append("|").append(EOS).append("|").append(punct.getType());
                }
                features.add(feat.toString());
                feat.setLength(0);
                feat.append("s").append(i).append("*=");
                feat.append(type).append("|").append(punct.getType());
                features.add(feat.toString());
            }
        } else {
            if (node != null) {
                feat.append(node.getHead().getCoveredText()).append("|").append(type).append("|").append(node.getType());
            } else {
                feat.append(type).append("|").append(EOS);
            }
            features.add(feat.toString());
            feat.setLength(0);
            feat.append("s").append(i).append("*=");
            if (node != null) {
                feat.append(type).append("|").append(node.getType());
            } else {
                feat.append(type).append("|").append(EOS);
            }
            features.add(feat.toString());
        }
    }

    protected void checkcons(Parse child, String i, String type, List<String> features) {
        StringBuilder feat = new StringBuilder(20);
        feat.append("c").append(i).append("=").append(child.getType()).append("|").append(child.getHead().getCoveredText()).append("|").append(type);
        features.add(feat.toString());
        feat.setLength(0);
        feat.append("c").append(i).append("*=").append(child.getType()).append("|").append(type);
        features.add(feat.toString());
    }

    protected void checkcons(Parse p1, Parse p2, String type, List<String> features) {
        StringBuilder feat = new StringBuilder(20);
        feat.append("cil=").append(type).append(",").append(p1.getType()).append("|").append(p1.getHead().getCoveredText()).append(",").append(p2.getType()).append("|").append(p2.getHead().getCoveredText());
        features.add(feat.toString());
        feat.setLength(0);
        feat.append("ci*l=").append(type).append(",").append(p1.getType()).append(",").append(p2.getType()).append("|").append(p2.getHead().getCoveredText());
        features.add(feat.toString());
        feat.setLength(0);
        feat.append("cil*=").append(type).append(",").append(p1.getType()).append("|").append(p1.getHead().getCoveredText()).append(",").append(p2.getType());
        features.add(feat.toString());
        feat.setLength(0);
        feat.append("ci*l*=").append(type).append(",").append(p1.getType()).append(",").append(p2.getType());
        features.add(feat.toString());
    }

    protected void getFrontierNodes(List<Parse> rf, Parse[] nodes) {
        int leftIndex = 0;
        int prevHeadIndex = -1;
        for (Parse fn : rf) {
            int headIndex = fn.getHeadIndex();
            if (headIndex == prevHeadIndex) continue;
            nodes[leftIndex] = fn;
            prevHeadIndex = headIndex;
            if (++leftIndex != nodes.length) continue;
            break;
        }
        for (int ni = leftIndex; ni < nodes.length; ++ni) {
            nodes[ni] = null;
        }
    }
}

