/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.core.util.Durations;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.Retry;

public interface RetryConfig
extends Retry,
Config {
    default public void validate() {
        long delay;
        if (this.maxRetries() < -1) {
            throw this.fail("maxRetries", "shouldn't be lower than -1");
        }
        if (this.delay() < 0L) {
            throw this.fail("delay", "shouldn't be lower than 0");
        }
        if (this.maxDuration() < 0L) {
            throw this.fail("maxDuration", "shouldn't be lower than 0");
        }
        long maxDuration = Durations.timeInMillis((long)this.maxDuration(), (ChronoUnit)this.durationUnit());
        if (maxDuration > 0L && maxDuration <= (delay = Durations.timeInMillis((long)this.delay(), (ChronoUnit)this.delayUnit()))) {
            throw this.fail("maxDuration", "should be greater than delay");
        }
        if (this.jitter() < 0L) {
            throw this.fail("jitter", "shouldn't be lower than 0");
        }
    }
}

