/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.invocation;

import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;

public class NormalMethodInvoker<V>
implements Invoker<V> {
    private final Method method;
    private final Object target;
    private final Object[] arguments;

    public NormalMethodInvoker(Method method, Object target, Object[] arguments) {
        Preconditions.checkNotNull(arguments, "Arguments array must be set");
        Preconditions.check(arguments.length, arguments.length == method.getParameterCount(), "Argument array length must be " + method.getParameterCount());
        this.method = method;
        this.target = target;
        this.arguments = arguments;
    }

    @Override
    public int parametersCount() {
        return this.method.getParameterCount();
    }

    @Override
    public <T> T getArgument(int index, Class<T> parameterType) {
        return parameterType.cast(this.arguments[index]);
    }

    @Override
    public <T> T replaceArgument(int index, Class<T> parameterType, Function<T, T> transformation) {
        T oldArg = parameterType.cast(this.arguments[index]);
        T newArg = transformation.apply(oldArg);
        this.arguments[index] = newArg;
        return oldArg;
    }

    @Override
    public V proceed() throws InvocationTargetException, IllegalAccessException {
        return (V)this.method.invoke(this.target, this.arguments);
    }
}

