/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.apache.iceberg.catalog.Namespace;

public class PolicyIdentifier {
    private final Namespace namespace;
    private final String name;

    @ApiModelProperty(example="[\"accounting\",\"tax\"]", required=true, value="Reference to one or more levels of a namespace")
    @JsonProperty(value="namespace", required=true)
    public Namespace getNamespace() {
        return this.namespace;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @JsonCreator
    public PolicyIdentifier(@JsonProperty(value="namespace", required=true) Namespace namespace, @JsonProperty(value="name", required=true) String name) {
        this.namespace = Objects.requireNonNullElse(namespace, Namespace.empty());
        this.name = name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Namespace namespace, String name) {
        return new Builder(namespace, name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolicyIdentifier)) {
            return false;
        }
        PolicyIdentifier policyIdentifier = (PolicyIdentifier)o;
        return Objects.equals(this.namespace, policyIdentifier.namespace) && Objects.equals(this.name, policyIdentifier.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyIdentifier {\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private Namespace namespace;
        private String name;

        private Builder() {
        }

        private Builder(Namespace namespace, String name) {
            this.namespace = Objects.requireNonNullElse(namespace, Namespace.empty());
            this.name = name;
        }

        public Builder setNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public PolicyIdentifier build() {
            PolicyIdentifier inst = new PolicyIdentifier(this.namespace, this.name);
            return inst;
        }
    }
}

