/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.spi.Page;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PageRecordSet
implements RecordSet {
    private final List<Type> types;
    private final Page page;

    public PageRecordSet(List<Type> types, Page page) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.page = Objects.requireNonNull(page, "page is null");
        Preconditions.checkArgument((types.size() == page.getChannelCount() ? 1 : 0) != 0, (Object)"Types do not match page channels");
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public RecordCursor cursor() {
        return new PageRecordCursor(this.types, this.page);
    }

    public static class PageRecordCursor
    implements RecordCursor {
        private final List<Type> types;
        private final Page page;
        private int position = -1;

        private PageRecordCursor(List<Type> types, Page page) {
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.page = Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((types.size() == page.getChannelCount() ? 1 : 0) != 0, (Object)"Types do not match page channels");
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return this.types.get(field);
        }

        public boolean advanceNextPosition() {
            ++this.position;
            return this.position < this.page.getPositionCount();
        }

        public boolean getBoolean(int field) {
            Preconditions.checkState((this.position >= 0 ? 1 : 0) != 0, (Object)"Not yet advanced");
            Preconditions.checkState((this.position < this.page.getPositionCount() ? 1 : 0) != 0, (Object)"Already finished");
            Type type = this.types.get(field);
            return type.getBoolean(this.page.getBlock(field), this.position);
        }

        public long getLong(int field) {
            Preconditions.checkState((this.position >= 0 ? 1 : 0) != 0, (Object)"Not yet advanced");
            Preconditions.checkState((this.position < this.page.getPositionCount() ? 1 : 0) != 0, (Object)"Already finished");
            Type type = this.types.get(field);
            return type.getLong(this.page.getBlock(field), this.position);
        }

        public double getDouble(int field) {
            Preconditions.checkState((this.position >= 0 ? 1 : 0) != 0, (Object)"Not yet advanced");
            Preconditions.checkState((this.position < this.page.getPositionCount() ? 1 : 0) != 0, (Object)"Already finished");
            Type type = this.types.get(field);
            return type.getDouble(this.page.getBlock(field), this.position);
        }

        public Slice getSlice(int field) {
            Preconditions.checkState((this.position >= 0 ? 1 : 0) != 0, (Object)"Not yet advanced");
            Preconditions.checkState((this.position < this.page.getPositionCount() ? 1 : 0) != 0, (Object)"Already finished");
            Type type = this.types.get(field);
            return type.getSlice(this.page.getBlock(field), this.position);
        }

        public Object getObject(int field) {
            Preconditions.checkState((this.position >= 0 ? 1 : 0) != 0, (Object)"Not yet advanced");
            Preconditions.checkState((this.position < this.page.getPositionCount() ? 1 : 0) != 0, (Object)"Already finished");
            Type type = this.types.get(field);
            return type.getObject(this.page.getBlock(field), this.position);
        }

        public boolean isNull(int field) {
            Preconditions.checkState((this.position >= 0 ? 1 : 0) != 0, (Object)"Not yet advanced");
            Preconditions.checkState((this.position < this.page.getPositionCount() ? 1 : 0) != 0, (Object)"Already finished");
            return this.page.getBlock(field).isNull(this.position);
        }

        public void close() {
        }
    }
}

