/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;

public class PulsarAuth {
    private static final Logger log = Logger.get(PulsarAuth.class);
    private final PulsarConnectorConfig pulsarConnectorConfig;
    private static final String CREDENTIALS_AUTH_PLUGIN = "auth-plugin";
    private static final String CREDENTIALS_AUTH_PARAMS = "auth-params";
    @VisibleForTesting
    final Map<String, Set<String>> authorizedQueryTopicsMap = new ConcurrentHashMap<String, Set<String>>();

    @Inject
    public PulsarAuth(PulsarConnectorConfig pulsarConnectorConfig) {
        this.pulsarConnectorConfig = pulsarConnectorConfig;
        if (pulsarConnectorConfig.getAuthorizationEnabled() && StringUtils.isEmpty((CharSequence)pulsarConnectorConfig.getBrokerBinaryServiceUrl())) {
            throw new IllegalArgumentException("pulsar.broker-binary-service-url must be present when the pulsar.authorization-enable is true.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTopicAuth(ConnectorSession session, String topic) {
        Map extraCredentials;
        Set authorizedTopics = this.authorizedQueryTopicsMap.computeIfAbsent(session.getQueryId(), query -> new HashSet());
        if (authorizedTopics.contains(topic)) {
            if (log.isDebugEnabled()) {
                log.debug("The topic %s is already authorized.", new Object[]{topic});
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Checking the authorization for the topic: %s", new Object[]{topic});
        }
        if ((extraCredentials = session.getIdentity().getExtraCredentials()).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to check the authorization for topic %s: The credential information is empty.", topic));
        }
        String authMethod = (String)extraCredentials.get(CREDENTIALS_AUTH_PLUGIN);
        String authParams = (String)extraCredentials.get(CREDENTIALS_AUTH_PARAMS);
        if (StringUtils.isEmpty((CharSequence)authMethod) || StringUtils.isEmpty((CharSequence)authParams)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to check the authorization for topic %s: Required credential parameters are missing. Please specify the auth-method and auth-params in the extra credentials.", topic));
        }
        try {
            PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsarConnectorConfig.getBrokerBinaryServiceUrl()).authentication(authMethod, authParams).build();
            try {
                client.newConsumer().topic(new String[]{topic}).subscriptionName("pulsar-sql-auth" + session.getQueryId()).subscriptionType(SubscriptionType.Exclusive).subscriptionMode(SubscriptionMode.NonDurable).startPaused(true).subscribe().close();
                this.authorizedQueryTopicsMap.computeIfPresent(session.getQueryId(), (query, topics) -> {
                    topics.add(topic);
                    return topics;
                });
                if (log.isDebugEnabled()) {
                    log.debug("Check the authorization for the topic %s successfully.", new Object[]{topic});
                }
            }
            finally {
                if (Collections.singletonList(client).get(0) != null) {
                    client.close();
                }
            }
        }
        catch (PulsarClientException.AuthenticationException | PulsarClientException.AuthorizationException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, String.format("Failed to access topic %s: %s", topic, e.getLocalizedMessage()));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to check authorization for topic %s: %s", topic, e.getLocalizedMessage()));
        }
    }

    public void cleanSession(ConnectorSession session) {
        this.authorizedQueryTopicsMap.remove(session.getQueryId());
    }
}

