/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.jdk8;

import java.util.stream.DoubleStream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public class DoubleStreamSerializer
extends StdSerializer<DoubleStream> {
    public static final DoubleStreamSerializer INSTANCE = new DoubleStreamSerializer();

    private DoubleStreamSerializer() {
        super(DoubleStream.class);
    }

    @Override
    public void serialize(DoubleStream stream, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        try (DoubleStream ds = stream;){
            g.writeStartArray((Object)ds);
            ds.forEach(value -> g.writeNumber(value));
            g.writeEndArray();
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, (Object)stream, g.streamWriteContext().getCurrentIndex());
        }
    }
}

