/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine;

import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.engine.Connection;
import org.apache.qpid.protonj2.engine.EngineConfiguration;
import org.apache.qpid.protonj2.engine.EnginePipeline;
import org.apache.qpid.protonj2.engine.EngineSaslDriver;
import org.apache.qpid.protonj2.engine.EngineState;
import org.apache.qpid.protonj2.engine.EventHandler;
import org.apache.qpid.protonj2.engine.Scheduler;
import org.apache.qpid.protonj2.engine.exceptions.EngineStateException;

public interface Engine
extends Consumer<ProtonBuffer> {
    public boolean isWritable();

    public boolean isRunning();

    public boolean isShutdown();

    public boolean isFailed();

    public Throwable failureCause();

    public EngineState state();

    public Connection connection();

    public Connection start() throws EngineStateException;

    public Engine shutdown();

    public EngineStateException engineFailed(Throwable var1);

    public Engine ingest(ProtonBuffer var1) throws EngineStateException;

    @Override
    default public void accept(ProtonBuffer input) throws EngineStateException {
        this.ingest(input);
    }

    public long tick(long var1) throws IllegalStateException, EngineStateException;

    public Engine tickAuto(ScheduledExecutorService var1) throws IllegalStateException, EngineStateException;

    public Engine tickAuto(Scheduler var1) throws IllegalStateException, EngineStateException;

    public EnginePipeline pipeline();

    public EngineConfiguration configuration();

    public EngineSaslDriver saslDriver();

    default public Engine outputHandler(EventHandler<ProtonBuffer> output) {
        return this.outputHandler((ProtonBuffer buffer, Runnable ioComplete) -> {
            output.handle((ProtonBuffer)buffer);
            if (ioComplete != null) {
                ioComplete.run();
            }
        });
    }

    default public Engine outputConsumer(Consumer<ProtonBuffer> consumer) {
        return this.outputHandler((ProtonBuffer buffer, Runnable ioComplete) -> {
            consumer.accept((ProtonBuffer)buffer);
            if (ioComplete != null) {
                ioComplete.run();
            }
        });
    }

    public Engine outputHandler(BiConsumer<ProtonBuffer, Runnable> var1);

    public Engine errorHandler(EventHandler<Engine> var1);

    public Engine shutdownHandler(EventHandler<Engine> var1);
}

