/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v11;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.util.PhMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class PhResultList<T, R>
implements List<R> {
    abstract PhEntry<T> phGetTempEntry();

    abstract void phReturnTemp(PhEntry<T> var1);

    abstract void phOffer(PhEntry<T> var1);

    abstract boolean phIsPrefixValid(long[] var1, int var2);

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<R> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(R e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iterator = c.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            return this.contains(o);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends R> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends R> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public R set(int index, R element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, R element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public R remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<R> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<R> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<R> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    static class MappingResultList<T, R>
    extends PhResultList<T, R> {
        private final ArrayList<R> list = new ArrayList();
        private PhEntry<T> free;
        private final PhFilter filter;
        private final PhMapper<T, R> mapper;
        private final PhEntryFactory<T> factory;

        public MappingResultList(PhFilter filter, PhMapper<T, R> mapper, PhEntryFactory<T> factory) {
            this.free = factory.create();
            this.filter = filter;
            this.mapper = mapper;
            this.factory = factory;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public R get(int index) {
            return this.list.get(index);
        }

        @Override
        PhEntry<T> phGetTempEntry() {
            PhEntry<T> ret = this.free;
            this.free = null;
            return ret;
        }

        @Override
        void phReturnTemp(PhEntry<T> entry) {
            if (this.free == null) {
                this.free = entry;
            }
        }

        @Override
        void phOffer(PhEntry<T> e) {
            if (this.filter == null || this.filter.isValid(e.getKey())) {
                R e2 = this.mapper.map(e);
                this.list.add(e2);
                this.free = e == e2 ? this.factory.create() : e;
            } else {
                this.free = e;
            }
        }

        @Override
        boolean phIsPrefixValid(long[] prefix, int bitsToIgnore) {
            return this.filter == null || this.filter.isValid(bitsToIgnore, prefix);
        }

        @Override
        public Iterator<R> iterator() {
            return Collections.unmodifiableList(this.list).iterator();
        }
    }

    static class SimpleArrayResultList<T>
    extends PhResultList<T, PhEntry<T>> {
        private final ArrayList<PhEntry<T>> list = new ArrayList();
        private PhEntry<T> free;
        private final PhFilter filter;

        public SimpleArrayResultList(int dims, PhFilter filter) {
            this.free = new PhEntry<Object>(new long[dims], null);
            this.filter = filter;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public PhEntry<T> get(int index) {
            return this.list.get(index);
        }

        @Override
        PhEntry<T> phGetTempEntry() {
            PhEntry<T> ret = this.free;
            this.free = null;
            return ret;
        }

        @Override
        void phReturnTemp(PhEntry<T> entry) {
            if (this.free == null) {
                this.free = entry;
            }
        }

        @Override
        void phOffer(PhEntry<T> e) {
            if (this.filter == null || this.filter.isValid(e.getKey())) {
                this.list.add(e);
                this.free = new PhEntry<Object>(new long[e.getKey().length], null);
            } else {
                this.free = e;
            }
        }

        @Override
        boolean phIsPrefixValid(long[] prefix, int bitsToIgnore) {
            return this.filter == null || this.filter.isValid(bitsToIgnore, prefix);
        }
    }

    @FunctionalInterface
    public static interface PhResultMapper<T, R> {
        public static <T> PhResultMapper<T, PhEntry<T>> NO_MAP() {
            return e -> e;
        }

        public R map(PhEntry<T> var1);
    }

    @FunctionalInterface
    static interface PhEntryFactory<T> {
        public PhEntry<T> create();
    }
}

