/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.iterators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.features.TagsResolver;
import org.apache.sedona.sql.datasources.osmpbf.model.OSMEntity;
import org.apache.sedona.sql.datasources.osmpbf.model.Way;

public class WayIterator
implements Iterator<OSMEntity> {
    int idx = 0;
    long waysCount = 0L;
    List<Osmformat.Way> ways;
    Osmformat.StringTable stringTable;

    public WayIterator(List<Osmformat.Way> ways, Osmformat.StringTable stringTable) {
        this.ways = ways;
        this.stringTable = stringTable;
        if (ways != null) {
            this.waysCount = ways.size();
        }
    }

    @Override
    public boolean hasNext() {
        return (long)this.idx < this.waysCount;
    }

    @Override
    public Way next() {
        if ((long)this.idx < this.waysCount) {
            Way way = this.extract(this.idx);
            ++this.idx;
            return way;
        }
        return null;
    }

    private Way extract(int idx) {
        Osmformat.Way way = this.ways.get(idx);
        return this.parse(way);
    }

    private Way parse(Osmformat.Way way) {
        long[] refs = new long[way.getRefsCount()];
        long firstRef = 0L;
        if (way.getRefsCount() != 0) {
            for (int i = 0; i < way.getRefsCount(); ++i) {
                refs[i] = firstRef += way.getRefs(i);
            }
        }
        HashMap<String, String> tags = TagsResolver.resolveTags(way.getKeysCount(), way::getKeys, way::getVals, this.stringTable);
        return new Way(way.getId(), tags, refs);
    }
}

