/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.oracle.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.shardingsphere.database.connector.core.resultset.DialectResultSetMapper;

public final class OracleResultSetMapper
implements DialectResultSetMapper {
    private static final int ORACLE_TIMESTAMP_WITH_TIME_ZONE = -101;
    private static final int ORACLE_TIMESTAMP_WITH_LOCAL_TIME_ZONE = -102;

    public Object getSmallintValue(ResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.getInt(columnIndex);
    }

    public Object getDateValue(ResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.getDate(columnIndex);
    }

    public Object getDefaultValue(ResultSet resultSet, int columnIndex, int columnType) throws SQLException {
        return this.isOracleTimestampWithTimeZone(columnType) ? resultSet.getTimestamp(columnIndex) : resultSet.getObject(columnIndex);
    }

    private boolean isOracleTimestampWithTimeZone(int columnType) {
        return -101 == columnType || -102 == columnType;
    }

    public String getDatabaseType() {
        return "Oracle";
    }
}

