/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.mysql;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.generic.DialectToBeRemovedSegmentsProvider;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.column.MySQLShowColumnsStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.index.MySQLShowIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTablesStatement;

public final class MySQLToBeRemovedSegmentsProvider
implements DialectToBeRemovedSegmentsProvider {
    public Collection<SQLSegment> getToBeRemovedSQLSegments(SQLStatement sqlStatement) {
        LinkedList<SQLSegment> result = new LinkedList<SQLSegment>();
        if (sqlStatement instanceof MySQLShowTablesStatement) {
            ((MySQLShowTablesStatement)sqlStatement).getFromDatabase().ifPresent(result::add);
        }
        if (sqlStatement instanceof MySQLShowColumnsStatement) {
            ((MySQLShowColumnsStatement)sqlStatement).getFromDatabase().ifPresent(result::add);
        }
        if (sqlStatement instanceof MySQLShowIndexStatement) {
            ((MySQLShowIndexStatement)sqlStatement).getFromDatabase().ifPresent(result::add);
        }
        if (sqlStatement instanceof MySQLShowTableStatusStatement) {
            ((MySQLShowTableStatusStatement)sqlStatement).getFromDatabase().ifPresent(result::add);
        }
        return result;
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

