/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.pojo.PipelineJobInfo;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobType;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.queryable.ShowMigrationListStatement;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.ShardingInfo;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowMigrationListExecutor
implements DistSQLQueryExecutor<ShowMigrationListStatement> {
    private final PipelineJobManager pipelineJobManager = new PipelineJobManager((PipelineJobType)new MigrationJobType());

    public Collection<String> getColumnNames(ShowMigrationListStatement sqlStatement) {
        return Arrays.asList("id", "tables", "active", "create_time", "stop_time", "job_item_count", "job_sharding_nodes");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowMigrationListStatement sqlStatement, ContextManager contextManager) {
        PipelineContextKey contextKey = new PipelineContextKey(InstanceType.PROXY);
        return this.pipelineJobManager.getJobInfos(contextKey).stream().map(each -> this.getRow(contextKey, (PipelineJobInfo)each)).collect(Collectors.toList());
    }

    private LocalDataQueryResultRow getRow(PipelineContextKey contextKey, PipelineJobInfo jobInfo) {
        boolean active = jobInfo.getMetaData().isActive();
        String jobShardingNodes = active ? this.getJobShardingNodes(contextKey, jobInfo.getMetaData().getJobId()) : "";
        return new LocalDataQueryResultRow(new Object[]{jobInfo.getMetaData().getJobId(), jobInfo.getTarget().getTableName(), active, jobInfo.getMetaData().getCreateTime(), jobInfo.getMetaData().getStopTime(), jobInfo.getMetaData().getJobItemCount(), jobShardingNodes});
    }

    private String getJobShardingNodes(PipelineContextKey contextKey, String jobId) {
        Collection shardingInfos;
        try {
            shardingInfos = this.pipelineJobManager.getJobShardingInfos(contextKey, jobId);
        }
        catch (RuntimeException ignored) {
            return "";
        }
        return shardingInfos.isEmpty() ? "" : this.getJobShardingNodes(shardingInfos);
    }

    private String getJobShardingNodes(Collection<ShardingInfo> shardingInfos) {
        return 1 == shardingInfos.size() ? shardingInfos.iterator().next().getInstanceId() : shardingInfos.stream().map(each -> each.getItem() + "=" + each.getInstanceId()).collect(Collectors.joining(","));
    }

    public Class<ShowMigrationListStatement> getType() {
        return ShowMigrationListStatement.class;
    }
}

