/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.InUsedAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.statement.CreateDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public final class CreateDefaultShadowAlgorithmExecutor
implements DatabaseRuleCreateExecutor<CreateDefaultShadowAlgorithmStatement, ShadowRule, ShadowRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShadowRule rule;

    public void checkBeforeUpdate(CreateDefaultShadowAlgorithmStatement sqlStatement) {
        if (!sqlStatement.isIfNotExists()) {
            this.checkAlgorithmExisted();
        }
        this.checkAlgorithmCompleteness(sqlStatement);
        this.checkAlgorithmType(sqlStatement);
    }

    private void checkAlgorithmExisted() {
        boolean isDuplicatedAlgorithmName = null != this.rule && this.rule.containsShadowAlgorithm("default_shadow_algorithm");
        ShardingSpherePreconditions.checkState((!isDuplicatedAlgorithmName ? 1 : 0) != 0, () -> new InUsedAlgorithmException("Shadow", this.database.getName(), Collections.singleton("default_shadow_algorithm")));
    }

    private void checkAlgorithmCompleteness(CreateDefaultShadowAlgorithmStatement sqlStatement) {
        ShardingSpherePreconditions.checkNotEmpty((String)sqlStatement.getShadowAlgorithmSegment().getAlgorithmSegment().getName(), () -> new MissingRequiredAlgorithmException("Shadow", new SQLExceptionIdentifier(this.database.getName())));
    }

    private void checkAlgorithmType(CreateDefaultShadowAlgorithmStatement sqlStatement) {
        AlgorithmSegment shadowAlgorithmType = sqlStatement.getShadowAlgorithmSegment().getAlgorithmSegment();
        TypedSPILoader.checkService(ShadowAlgorithm.class, (Object)shadowAlgorithmType.getName(), (Properties)shadowAlgorithmType.getProps());
    }

    public ShadowRuleConfiguration buildToBeCreatedRuleConfiguration(CreateDefaultShadowAlgorithmStatement sqlStatement) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        if (null == this.rule || !this.rule.containsShadowAlgorithm("default_shadow_algorithm")) {
            result.setShadowAlgorithms(this.buildAlgorithmMap(sqlStatement));
            result.setDefaultShadowAlgorithmName("default_shadow_algorithm");
        }
        return result;
    }

    private Map<String, AlgorithmConfiguration> buildAlgorithmMap(CreateDefaultShadowAlgorithmStatement sqlStatement) {
        return Collections.singletonMap("default_shadow_algorithm", new AlgorithmConfiguration(sqlStatement.getShadowAlgorithmSegment().getAlgorithmSegment().getName(), sqlStatement.getShadowAlgorithmSegment().getAlgorithmSegment().getProps()));
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<CreateDefaultShadowAlgorithmStatement> getType() {
        return CreateDefaultShadowAlgorithmStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

