/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule.changed;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;
import org.apache.shardingsphere.readwritesplitting.transaction.TransactionalReadQueryStrategy;
import org.apache.shardingsphere.readwritesplitting.yaml.config.rule.YamlReadwriteSplittingDataSourceGroupRuleConfiguration;

public final class ReadwriteSplittingDataSourceChangedProcessor
implements RuleItemConfigurationChangedProcessor<ReadwriteSplittingRuleConfiguration, ReadwriteSplittingDataSourceGroupRuleConfiguration> {
    public ReadwriteSplittingDataSourceGroupRuleConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        YamlReadwriteSplittingDataSourceGroupRuleConfiguration yamlDataSourceGroupRuleConfig = (YamlReadwriteSplittingDataSourceGroupRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlReadwriteSplittingDataSourceGroupRuleConfiguration.class);
        return new ReadwriteSplittingDataSourceGroupRuleConfiguration(itemName, yamlDataSourceGroupRuleConfig.getWriteDataSourceName(), yamlDataSourceGroupRuleConfig.getReadDataSourceNames(), this.getTransactionalReadQueryStrategy(yamlDataSourceGroupRuleConfig), yamlDataSourceGroupRuleConfig.getLoadBalancerName());
    }

    private TransactionalReadQueryStrategy getTransactionalReadQueryStrategy(YamlReadwriteSplittingDataSourceGroupRuleConfiguration yamlDataSourceGroupRuleConfig) {
        return Strings.isNullOrEmpty((String)yamlDataSourceGroupRuleConfig.getTransactionalReadQueryStrategy()) ? TransactionalReadQueryStrategy.PRIMARY : TransactionalReadQueryStrategy.valueOf((String)yamlDataSourceGroupRuleConfig.getTransactionalReadQueryStrategy());
    }

    public ReadwriteSplittingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ReadwriteSplittingRule.class).map(ReadwriteSplittingRule::getConfiguration).orElseGet(() -> new ReadwriteSplittingRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    public void changeRuleItemConfiguration(String itemName, ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingDataSourceGroupRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getDataSourceGroups().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getDataSourceGroups().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getDataSourceGroups().removeIf(each -> each.getName().equals(itemName));
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("readwrite_splitting", "data_source_groups");
    }
}

